/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.expressions.AbstractEvaluatedExpression;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public class AnnotationMetadataWriter
extends AbstractClassFileWriter {
    private static final Type TYPE_DEFAULT_ANNOTATION_METADATA = Type.getType(DefaultAnnotationMetadata.class);
    private static final Type TYPE_DEFAULT_ANNOTATION_METADATA_HIERARCHY = Type.getType(AnnotationMetadataHierarchy.class);
    private static final Type TYPE_ANNOTATION_CLASS_VALUE = Type.getType(AnnotationClassValue.class);
    private static final Method METHOD_REGISTER_ANNOTATION_DEFAULTS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(DefaultAnnotationMetadata.class, (String)"registerAnnotationDefaults", (Class[])new Class[]{AnnotationClassValue.class, Map.class}));
    private static final Method METHOD_REGISTER_ANNOTATION_TYPE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(DefaultAnnotationMetadata.class, (String)"registerAnnotationType", (Class[])new Class[]{AnnotationClassValue.class}));
    private static final Method METHOD_REGISTER_REPEATABLE_ANNOTATIONS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(DefaultAnnotationMetadata.class, (String)"registerRepeatableAnnotations", (Class[])new Class[]{Map.class}));
    private static final Method METHOD_GET_DEFAULT_VALUES = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AnnotationMetadataSupport.class, (String)"getDefaultValues", (Class[])new Class[]{String.class}));
    private static final Method CONSTRUCTOR_ANNOTATION_METADATA = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(DefaultAnnotationMetadata.class, (Class[])new Class[]{Map.class, Map.class, Map.class, Map.class, Map.class, Boolean.TYPE, Boolean.TYPE}));
    private static final Method CONSTRUCTOR_ANNOTATION_METADATA_HIERARCHY = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationMetadataHierarchy.class, (Class[])new Class[]{AnnotationMetadata[].class}));
    private static final Method CONSTRUCTOR_ANNOTATION_VALUE_AND_MAP = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationValue.class, (Class[])new Class[]{String.class, Map.class, Map.class}));
    private static final Method CONSTRUCTOR_CLASS_VALUE = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationClassValue.class, (Class[])new Class[]{String.class}));
    private static final Method CONSTRUCTOR_CLASS_VALUE_WITH_CLASS = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationClassValue.class, (Class[])new Class[]{Class.class}));
    private static final Method CONSTRUCTOR_CLASS_VALUE_WITH_INSTANCE = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationClassValue.class, (Class[])new Class[]{Object.class}));
    private static final Method CONSTRUCTOR_CONTEXT_EVALUATED_EXPRESSION = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AbstractEvaluatedExpression.class, (Class[])new Class[]{Object.class}));
    private static final String LOAD_CLASS_PREFIX = "$micronaut_load_class_value_";
    private final String className;
    private final AnnotationMetadata annotationMetadata;
    private final boolean writeAnnotationDefaults;

    @Deprecated
    public AnnotationMetadataWriter(String className, ClassElement originatingElement, AnnotationMetadata annotationMetadata, boolean writeAnnotationDefaults) {
        super(originatingElement);
        this.className = className + "$$AnnotationMetadata";
        if (annotationMetadata instanceof AnnotationMetadataDelegate) {
            annotationMetadata = ((AnnotationMetadataDelegate)annotationMetadata).getAnnotationMetadata();
        }
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            this.annotationMetadata = annotationMetadata;
        } else if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
            this.annotationMetadata = annotationMetadataHierarchy.getDeclaredMetadata();
        } else {
            throw new ClassGenerationException("Compile time metadata required to generate class: " + className);
        }
        this.writeAnnotationDefaults = writeAnnotationDefaults;
    }

    @Deprecated
    public AnnotationMetadataWriter(String className, ClassElement originatingElement, AnnotationMetadata annotationMetadata) {
        this(className, originatingElement, annotationMetadata, false);
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void accept(ClassWriterOutputVisitor outputVisitor) throws IOException {
        ClassWriter classWriter = this.generateClassBytes();
        if (classWriter != null) {
            try (OutputStream outputStream = outputVisitor.visitClass(this.className, this.getOriginatingElements());){
                outputStream.write(classWriter.toByteArray());
            }
        }
    }

    public void writeTo(OutputStream outputStream) {
        try {
            ClassWriter classWriter = this.generateClassBytes();
            this.writeClassToDisk(outputStream, classWriter);
        }
        catch (Throwable e) {
            throw new ClassGenerationException("Error generating annotation metadata: " + e.getMessage(), e);
        }
    }

    @Internal
    public static void instantiateNewMetadata(Type owningType, ClassWriter declaringClassWriter, GeneratorAdapter generatorAdapter, MutableAnnotationMetadata annotationMetadata, Map<String, Integer> defaultsStorage, Map<String, GeneratorAdapter> loadTypeMethods) {
        AnnotationMetadataWriter.instantiateInternal(owningType, declaringClassWriter, generatorAdapter, annotationMetadata, true, defaultsStorage, loadTypeMethods);
    }

    @Internal
    public static void instantiateNewMetadataHierarchy(Type owningType, ClassWriter classWriter, GeneratorAdapter generatorAdapter, AnnotationMetadataHierarchy hierarchy, Map<String, Integer> defaultsStorage, Map<String, GeneratorAdapter> loadTypeMethods) {
        if (hierarchy.isEmpty()) {
            generatorAdapter.getStatic(Type.getType(AnnotationMetadata.class), "EMPTY_METADATA", Type.getType(AnnotationMetadata.class));
            return;
        }
        List<AnnotationMetadata> notEmpty = CollectionUtils.iterableToList((Iterable)hierarchy).stream().filter(h -> !h.isEmpty()).toList();
        if (notEmpty.size() == 1) {
            AnnotationMetadataWriter.pushNewAnnotationMetadataOrReference(owningType, classWriter, generatorAdapter, defaultsStorage, loadTypeMethods, notEmpty.get(0));
            return;
        }
        generatorAdapter.visitTypeInsn(187, TYPE_DEFAULT_ANNOTATION_METADATA_HIERARCHY.getInternalName());
        generatorAdapter.visitInsn(89);
        AnnotationMetadataWriter.pushNewArray(generatorAdapter, AnnotationMetadata.class, 2);
        AnnotationMetadataWriter.pushStoreInArray(generatorAdapter, 0, 2, () -> {
            AnnotationMetadata rootMetadata = hierarchy.getRootMetadata();
            AnnotationMetadataWriter.pushNewAnnotationMetadataOrReference(owningType, classWriter, generatorAdapter, defaultsStorage, loadTypeMethods, rootMetadata);
        });
        AnnotationMetadataWriter.pushStoreInArray(generatorAdapter, 1, 2, () -> {
            AnnotationMetadata declaredMetadata = hierarchy.getDeclaredMetadata();
            AnnotationMetadataWriter.pushNewAnnotationMetadataOrReference(owningType, classWriter, generatorAdapter, defaultsStorage, loadTypeMethods, declaredMetadata);
        });
        generatorAdapter.invokeConstructor(TYPE_DEFAULT_ANNOTATION_METADATA_HIERARCHY, CONSTRUCTOR_ANNOTATION_METADATA_HIERARCHY);
    }

    @Internal
    public static void pushAnnotationMetadataReference(GeneratorAdapter generatorAdapter, AnnotationMetadataReference annotationMetadata) {
        String className = annotationMetadata.getClassName();
        Type type = AnnotationMetadataWriter.getTypeReferenceForName(className, new String[0]);
        generatorAdapter.getStatic(type, "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
    }

    @Internal
    private static void pushNewAnnotationMetadataOrReference(Type owningType, ClassWriter classWriter, GeneratorAdapter generatorAdapter, Map<String, Integer> defaultsStorage, Map<String, GeneratorAdapter> loadTypeMethods, AnnotationMetadata annotationMetadata) {
        if ((annotationMetadata = annotationMetadata.getTargetAnnotationMetadata()).isEmpty()) {
            generatorAdapter.getStatic(Type.getType(AnnotationMetadata.class), "EMPTY_METADATA", Type.getType(AnnotationMetadata.class));
        } else if (annotationMetadata instanceof MutableAnnotationMetadata) {
            MutableAnnotationMetadata mutableAnnotationMetadata = (MutableAnnotationMetadata)annotationMetadata;
            AnnotationMetadataWriter.instantiateNewMetadata(owningType, classWriter, generatorAdapter, mutableAnnotationMetadata, defaultsStorage, loadTypeMethods);
        } else if (annotationMetadata instanceof AnnotationMetadataReference) {
            AnnotationMetadataWriter.pushAnnotationMetadataReference(generatorAdapter, (AnnotationMetadataReference)annotationMetadata);
        } else {
            throw new IllegalStateException("Unknown annotation metadata: " + annotationMetadata);
        }
    }

    @Internal
    public static void writeAnnotationDefaults(MutableAnnotationMetadata annotationMetadata, ClassWriter classWriter, Type owningType, Map<String, Integer> defaultsStorage, Map<String, GeneratorAdapter> loadTypeMethods) {
        Map annotationDefaultValues = annotationMetadata.annotationDefaultValues;
        if (CollectionUtils.isNotEmpty((Map)annotationDefaultValues)) {
            MethodVisitor si = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
            GeneratorAdapter staticInit = new GeneratorAdapter(si, 8, "<clinit>", "()V");
            AnnotationMetadataWriter.writeAnnotationDefaults(owningType, classWriter, staticInit, annotationMetadata, defaultsStorage, loadTypeMethods);
            staticInit.visitInsn(177);
            staticInit.visitMaxs(1, 1);
            staticInit.visitEnd();
        }
    }

    @Internal
    public static void writeAnnotationDefaults(Type owningType, ClassWriter classWriter, GeneratorAdapter staticInit, MutableAnnotationMetadata annotationMetadata, Map<String, Integer> defaultsStorage, Map<String, GeneratorAdapter> loadTypeMethods) {
        Map annotationDefaultValues = annotationMetadata.annotationDefaultValues;
        if (CollectionUtils.isNotEmpty((Map)annotationDefaultValues)) {
            for (Map.Entry entry : annotationDefaultValues.entrySet()) {
                Map annotationValues = (Map)entry.getValue();
                boolean typeOnly = CollectionUtils.isEmpty((Map)annotationValues);
                String annotationName = (String)entry.getKey();
                if (typeOnly && AnnotationMetadataSupport.getRegisteredAnnotationType((String)annotationName).isPresent()) continue;
                AnnotationMetadataWriter.invokeLoadClassValueMethod(owningType, (ClassVisitor)classWriter, staticInit, loadTypeMethods, new AnnotationClassValue(annotationName));
                if (!typeOnly) {
                    AnnotationMetadataWriter.pushStringMapOf(staticInit, annotationValues, true, null, v -> AnnotationMetadataWriter.pushValue(owningType, (ClassVisitor)classWriter, staticInit, v, defaultsStorage, loadTypeMethods, true));
                    staticInit.invokeStatic(TYPE_DEFAULT_ANNOTATION_METADATA, METHOD_REGISTER_ANNOTATION_DEFAULTS);
                    continue;
                }
                staticInit.invokeStatic(TYPE_DEFAULT_ANNOTATION_METADATA, METHOD_REGISTER_ANNOTATION_TYPE);
            }
        }
        if (annotationMetadata.annotationRepeatableContainer != null && !annotationMetadata.annotationRepeatableContainer.isEmpty()) {
            AnnotationMetadataSupport.registerRepeatableAnnotations((Map)annotationMetadata.annotationRepeatableContainer);
            if (!annotationMetadata.annotationRepeatableContainer.isEmpty()) {
                AnnotationMetadataWriter.pushStringMapOf(staticInit, annotationMetadata.annotationRepeatableContainer, true, null, v -> AnnotationMetadataWriter.pushValue(owningType, (ClassVisitor)classWriter, staticInit, v, defaultsStorage, loadTypeMethods, true));
                staticInit.invokeStatic(TYPE_DEFAULT_ANNOTATION_METADATA, METHOD_REGISTER_REPEATABLE_ANNOTATIONS);
            }
        }
    }

    private static void instantiateInternal(Type owningType, ClassWriter declaringClassWriter, GeneratorAdapter generatorAdapter, MutableAnnotationMetadata annotationMetadata, boolean isNew, Map<String, Integer> defaultsStorage, Map<String, GeneratorAdapter> loadTypeMethods) {
        if (isNew) {
            generatorAdapter.visitTypeInsn(187, TYPE_DEFAULT_ANNOTATION_METADATA.getInternalName());
            generatorAdapter.visitInsn(89);
        } else {
            generatorAdapter.loadThis();
        }
        AnnotationMetadataWriter.pushCreateAnnotationData(owningType, declaringClassWriter, generatorAdapter, annotationMetadata.declaredAnnotations, defaultsStorage, loadTypeMethods, annotationMetadata.getSourceRetentionAnnotations());
        AnnotationMetadataWriter.pushCreateAnnotationData(owningType, declaringClassWriter, generatorAdapter, annotationMetadata.declaredStereotypes, defaultsStorage, loadTypeMethods, annotationMetadata.getSourceRetentionAnnotations());
        AnnotationMetadataWriter.pushCreateAnnotationData(owningType, declaringClassWriter, generatorAdapter, annotationMetadata.allStereotypes, defaultsStorage, loadTypeMethods, annotationMetadata.getSourceRetentionAnnotations());
        AnnotationMetadataWriter.pushCreateAnnotationData(owningType, declaringClassWriter, generatorAdapter, annotationMetadata.allAnnotations, defaultsStorage, loadTypeMethods, annotationMetadata.getSourceRetentionAnnotations());
        LinkedHashMap annotationsByStereotype = annotationMetadata.annotationsByStereotype;
        if (annotationMetadata.getSourceRetentionAnnotations() != null && annotationsByStereotype != null) {
            annotationsByStereotype = new LinkedHashMap(annotationsByStereotype);
            for (String sourceRetentionAnnotation : annotationMetadata.getSourceRetentionAnnotations()) {
                annotationsByStereotype.remove(sourceRetentionAnnotation);
            }
        }
        AnnotationMetadataWriter.pushStringMapOf(generatorAdapter, annotationsByStereotype, false, Collections.emptyList(), list -> AnnotationMetadataWriter.pushListOfString(generatorAdapter, list));
        generatorAdapter.push(annotationMetadata.hasPropertyExpressions());
        generatorAdapter.push(annotationMetadata.hasEvaluatedExpressions());
        generatorAdapter.invokeConstructor(TYPE_DEFAULT_ANNOTATION_METADATA, CONSTRUCTOR_ANNOTATION_METADATA);
    }

    private ClassWriter generateClassBytes() {
        ClassWriter classWriter = new ClassWriter(3);
        Type owningType = AnnotationMetadataWriter.getTypeReferenceForName(this.className, new String[0]);
        this.startClass((ClassVisitor)classWriter, AnnotationMetadataWriter.getInternalName(this.className), TYPE_DEFAULT_ANNOTATION_METADATA);
        GeneratorAdapter constructor = this.startConstructor((ClassVisitor)classWriter);
        MutableAnnotationMetadata annotationMetadata = (MutableAnnotationMetadata)this.annotationMetadata;
        HashMap<String, Integer> defaultsStorage = new HashMap<String, Integer>(3);
        HashMap<String, GeneratorAdapter> loadTypeMethods = new HashMap<String, GeneratorAdapter>(5);
        AnnotationMetadataWriter.instantiateInternal(owningType, classWriter, constructor, annotationMetadata, false, defaultsStorage, loadTypeMethods);
        constructor.visitInsn(177);
        constructor.visitMaxs(1, 1);
        constructor.visitEnd();
        defaultsStorage.clear();
        if (this.writeAnnotationDefaults) {
            AnnotationMetadataWriter.writeAnnotationDefaults(annotationMetadata, classWriter, owningType, defaultsStorage, loadTypeMethods);
        }
        for (GeneratorAdapter adapter : loadTypeMethods.values()) {
            adapter.visitMaxs(3, 1);
            adapter.visitEnd();
        }
        classWriter.visitEnd();
        return classWriter;
    }

    private static void pushCreateAnnotationData(Type declaringType, ClassWriter declaringClassWriter, GeneratorAdapter methodVisitor, Map<String, Map<CharSequence, Object>> annotationData, Map<String, Integer> defaultsStorage, Map<String, GeneratorAdapter> loadTypeMethods, Set<String> sourceRetentionAnnotations) {
        if (annotationData != null) {
            annotationData = new LinkedHashMap<String, Map<CharSequence, Object>>(annotationData);
            for (String sourceRetentionAnnotation : sourceRetentionAnnotations) {
                annotationData.remove(sourceRetentionAnnotation);
            }
        }
        AnnotationMetadataWriter.pushStringMapOf(methodVisitor, annotationData, false, Collections.emptyMap(), attributes -> AnnotationMetadataWriter.pushStringMapOf(methodVisitor, attributes, true, null, v -> AnnotationMetadataWriter.pushValue(declaringType, (ClassVisitor)declaringClassWriter, methodVisitor, v, defaultsStorage, loadTypeMethods, true)));
    }

    private static void pushValue(Type declaringType, ClassVisitor declaringClassWriter, GeneratorAdapter methodVisitor, Object value, Map<String, Integer> defaultsStorage, Map<String, GeneratorAdapter> loadTypeMethods, boolean boxValue) {
        if (value == null) {
            throw new IllegalStateException("Cannot map null value in: " + declaringType.getClassName());
        }
        if (value instanceof Boolean) {
            methodVisitor.push(((Boolean)value).booleanValue());
            if (boxValue) {
                AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Boolean.TYPE, (MethodVisitor)methodVisitor);
            }
        } else if (value instanceof String) {
            methodVisitor.push(value.toString());
        } else if (value instanceof AnnotationClassValue) {
            AnnotationClassValue acv = (AnnotationClassValue)value;
            if (acv.isInstantiated()) {
                methodVisitor.visitTypeInsn(187, TYPE_ANNOTATION_CLASS_VALUE.getInternalName());
                methodVisitor.visitInsn(89);
                methodVisitor.visitTypeInsn(187, AnnotationMetadataWriter.getInternalName(acv.getName()));
                methodVisitor.visitInsn(89);
                methodVisitor.invokeConstructor(AnnotationMetadataWriter.getTypeReferenceForName(acv.getName(), new String[0]), new Method("<init>", AnnotationMetadataWriter.getConstructorDescriptor(new Class[0])));
                methodVisitor.invokeConstructor(TYPE_ANNOTATION_CLASS_VALUE, CONSTRUCTOR_CLASS_VALUE_WITH_INSTANCE);
            } else {
                AnnotationMetadataWriter.invokeLoadClassValueMethod(declaringType, declaringClassWriter, methodVisitor, loadTypeMethods, acv);
            }
        } else if (value instanceof Enum) {
            Enum enumObject = (Enum)value;
            Class declaringClass = enumObject.getDeclaringClass();
            Type t = Type.getType(declaringClass);
            methodVisitor.getStatic(t, enumObject.name(), t);
        } else if (value.getClass().isArray()) {
            Class jt = ReflectionUtils.getPrimitiveType(value.getClass().getComponentType());
            Type componentType = Type.getType((Class)jt);
            int len = Array.getLength(value);
            if (Object.class == jt && len == 0) {
                AnnotationMetadataWriter.pushEmptyObjectsArray(methodVisitor);
            } else {
                AnnotationMetadataWriter.pushNewArray(methodVisitor, jt, len);
                for (int i = 0; i < len; ++i) {
                    Object v2 = Array.get(value, i);
                    AnnotationMetadataWriter.pushStoreInArray(methodVisitor, componentType, i, len, () -> AnnotationMetadataWriter.pushValue(declaringType, declaringClassWriter, methodVisitor, v2, defaultsStorage, loadTypeMethods, !jt.isPrimitive()));
                }
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                AnnotationMetadataWriter.pushEmptyObjectsArray(methodVisitor);
            } else {
                List array = CollectionUtils.iterableToList((Iterable)collection);
                int len = array.size();
                boolean first = true;
                Class<Object> arrayType = Object.class;
                for (int i = 0; i < len; ++i) {
                    Object v3 = array.get(i);
                    if (first) {
                        arrayType = v3 == null ? Object.class : v3.getClass();
                        AnnotationMetadataWriter.pushNewArray(methodVisitor, arrayType, len);
                        first = false;
                    }
                    Class<Object> finalArrayType = arrayType;
                    AnnotationMetadataWriter.pushStoreInArray(methodVisitor, Type.getType(arrayType), i, len, () -> AnnotationMetadataWriter.pushValue(declaringType, declaringClassWriter, methodVisitor, v3, defaultsStorage, loadTypeMethods, !finalArrayType.isPrimitive()));
                }
            }
        } else if (value instanceof Long) {
            methodVisitor.push(((Long)value).longValue());
            if (boxValue) {
                AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Long.TYPE, (MethodVisitor)methodVisitor);
            }
        } else if (value instanceof Double) {
            methodVisitor.push(((Double)value).doubleValue());
            if (boxValue) {
                AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Double.TYPE, (MethodVisitor)methodVisitor);
            }
        } else if (value instanceof Float) {
            methodVisitor.push(((Float)value).floatValue());
            if (boxValue) {
                AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Float.TYPE, (MethodVisitor)methodVisitor);
            }
        } else if (value instanceof Byte) {
            methodVisitor.push((int)((Byte)value).byteValue());
            if (boxValue) {
                AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Byte.TYPE, (MethodVisitor)methodVisitor);
            }
        } else if (value instanceof Short) {
            methodVisitor.push((int)((Short)value).shortValue());
            if (boxValue) {
                AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Short.TYPE, (MethodVisitor)methodVisitor);
            }
        } else if (value instanceof Character) {
            methodVisitor.push((int)((Character)value).charValue());
            if (boxValue) {
                AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Character.TYPE, (MethodVisitor)methodVisitor);
            }
        } else if (value instanceof Number) {
            methodVisitor.push(((Number)value).intValue());
            if (boxValue) {
                AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(ReflectionUtils.getPrimitiveType(value.getClass()), (MethodVisitor)methodVisitor);
            }
        } else if (value instanceof AnnotationValue) {
            AnnotationValue data = (AnnotationValue)value;
            String annotationName = data.getAnnotationName();
            Map values = data.getValues();
            Type annotationValueType = Type.getType(AnnotationValue.class);
            methodVisitor.newInstance(annotationValueType);
            methodVisitor.dup();
            methodVisitor.push(annotationName);
            AnnotationMetadataWriter.pushStringMapOf(methodVisitor, values, true, null, v -> AnnotationMetadataWriter.pushValue(declaringType, declaringClassWriter, methodVisitor, v, defaultsStorage, loadTypeMethods, true));
            Integer defaultIndex = defaultsStorage.get(annotationName);
            if (defaultIndex == null) {
                methodVisitor.push(annotationName);
                methodVisitor.invokeStatic(Type.getType(AnnotationMetadataSupport.class), METHOD_GET_DEFAULT_VALUES);
                methodVisitor.dup();
                int localIndex = methodVisitor.newLocal(Type.getType(Map.class));
                methodVisitor.storeLocal(localIndex);
                defaultsStorage.put(annotationName, localIndex);
            } else {
                methodVisitor.loadLocal(defaultIndex.intValue());
            }
            methodVisitor.invokeConstructor(annotationValueType, CONSTRUCTOR_ANNOTATION_VALUE_AND_MAP);
        } else if (value instanceof EvaluatedExpressionReference) {
            EvaluatedExpressionReference expressionReference = (EvaluatedExpressionReference)value;
            Type type = Type.getType((String)AnnotationMetadataWriter.getTypeDescriptor(expressionReference.expressionClassName()));
            methodVisitor.visitTypeInsn(187, type.getInternalName());
            methodVisitor.visitInsn(89);
            Object annotationValue = expressionReference.annotationValue();
            if (annotationValue instanceof String) {
                String str = (String)annotationValue;
                methodVisitor.push(str);
            } else if (annotationValue instanceof String[]) {
                String[] strings = (String[])annotationValue;
                int len = Array.getLength(strings);
                AnnotationMetadataWriter.pushNewArray(methodVisitor, String.class, len);
                for (int i = 0; i < len; ++i) {
                    Object v4 = Array.get(strings, i);
                    AnnotationMetadataWriter.pushStoreInArray(methodVisitor, Type.getType(String.class), i, len, () -> AnnotationMetadataWriter.pushValue(declaringType, declaringClassWriter, methodVisitor, v4, defaultsStorage, loadTypeMethods, false));
                }
            } else {
                throw new IllegalStateException();
            }
            methodVisitor.invokeConstructor(type, CONSTRUCTOR_CONTEXT_EVALUATED_EXPRESSION);
        } else {
            throw new IllegalStateException("Unsupported Map value:  " + value + " " + value.getClass().getName());
        }
    }

    public static boolean isSupportedMapValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof AnnotationClassValue) {
            return true;
        }
        if (value instanceof Enum) {
            return true;
        }
        if (value.getClass().isArray()) {
            return true;
        }
        if (value instanceof Collection) {
            return true;
        }
        if (value instanceof Map) {
            return true;
        }
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof Float) {
            return true;
        }
        if (value instanceof Byte) {
            return true;
        }
        if (value instanceof Short) {
            return true;
        }
        if (value instanceof Character) {
            return true;
        }
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof AnnotationValue) {
            return true;
        }
        if (value instanceof EvaluatedExpressionReference) {
            return true;
        }
        if (value instanceof Class) {
            return false;
        }
        return false;
    }

    private static void pushEmptyObjectsArray(GeneratorAdapter methodVisitor) {
        methodVisitor.getStatic(Type.getType(ArrayUtils.class), "EMPTY_OBJECT_ARRAY", Type.getType(Object[].class));
    }

    private static void invokeLoadClassValueMethod(Type declaringType, ClassVisitor declaringClassWriter, GeneratorAdapter methodVisitor, Map<String, GeneratorAdapter> loadTypeMethods, AnnotationClassValue acv) {
        String typeName = acv.getName();
        String desc = AnnotationMetadataWriter.getMethodDescriptor(AnnotationClassValue.class, Collections.emptyList());
        GeneratorAdapter loadTypeGeneratorMethod = loadTypeMethods.computeIfAbsent(typeName, type -> {
            String methodName = LOAD_CLASS_PREFIX + loadTypeMethods.size();
            GeneratorAdapter loadTypeGenerator = new GeneratorAdapter(declaringClassWriter.visitMethod(4104, methodName, desc, null, null), 4104, methodName, desc);
            loadTypeGenerator.visitCode();
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label exceptionHandler = new Label();
            loadTypeGenerator.visitTryCatchBlock(tryStart, tryEnd, exceptionHandler, Type.getInternalName(Throwable.class));
            loadTypeGenerator.visitLabel(tryStart);
            loadTypeGenerator.visitTypeInsn(187, TYPE_ANNOTATION_CLASS_VALUE.getInternalName());
            loadTypeGenerator.visitInsn(89);
            loadTypeGenerator.push(AnnotationMetadataWriter.getTypeReferenceForName(typeName, new String[0]));
            loadTypeGenerator.invokeConstructor(TYPE_ANNOTATION_CLASS_VALUE, CONSTRUCTOR_CLASS_VALUE_WITH_CLASS);
            loadTypeGenerator.visitLabel(tryEnd);
            loadTypeGenerator.returnValue();
            loadTypeGenerator.visitLabel(exceptionHandler);
            loadTypeGenerator.visitFrame(-1, 0, new Object[0], 1, new Object[]{"java/lang/Throwable"});
            loadTypeGenerator.visitVarInsn(58, 0);
            loadTypeGenerator.visitTypeInsn(187, TYPE_ANNOTATION_CLASS_VALUE.getInternalName());
            loadTypeGenerator.visitInsn(89);
            loadTypeGenerator.push(typeName);
            loadTypeGenerator.invokeConstructor(TYPE_ANNOTATION_CLASS_VALUE, CONSTRUCTOR_CLASS_VALUE);
            loadTypeGenerator.returnValue();
            return loadTypeGenerator;
        });
        methodVisitor.visitMethodInsn(184, declaringType.getInternalName(), loadTypeGeneratorMethod.getName(), desc, false);
    }
}

