/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Described;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface Element
extends MutableAnnotationMetadataDelegate<Element>,
AnnotatedElement,
Described {
    public static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];

    @NonNull
    public String getName();

    default public boolean isPackagePrivate() {
        return false;
    }

    default public boolean isSynthetic() {
        return false;
    }

    public boolean isProtected();

    public boolean isPublic();

    @NonNull
    public Object getNativeType();

    default public Set<ElementModifier> getModifiers() {
        return Collections.emptySet();
    }

    @NonNull
    default public String getSimpleName() {
        return this.getName();
    }

    default public boolean isAbstract() {
        return false;
    }

    default public boolean isStatic() {
        return false;
    }

    default public Optional<String> getDocumentation() {
        return Optional.empty();
    }

    default public boolean isPrivate() {
        return !this.isPublic();
    }

    default public boolean isFinal() {
        return false;
    }

    @NonNull
    default public String getDescription() {
        return this.getDescription(true);
    }

    @NonNull
    default public String getDescription(boolean simple) {
        if (simple) {
            return this.getSimpleName();
        }
        return this.getName();
    }

    default public Element withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support copy constructor");
    }

    @Override
    default public <T extends Annotation> Element annotate(String annotationType, Consumer<AnnotationValueBuilder<T>> consumer) {
        return (Element)MutableAnnotationMetadataDelegate.super.annotate(annotationType, consumer);
    }

    @Override
    default public Element removeAnnotation(String annotationType) {
        return (Element)MutableAnnotationMetadataDelegate.super.removeAnnotation(annotationType);
    }

    @Override
    default public <T extends Annotation> Element removeAnnotation(Class<T> annotationType) {
        return (Element)MutableAnnotationMetadataDelegate.super.removeAnnotation(annotationType);
    }

    @Override
    default public <T extends Annotation> Element removeAnnotationIf(Predicate<AnnotationValue<T>> predicate) {
        return (Element)MutableAnnotationMetadataDelegate.super.removeAnnotationIf(predicate);
    }

    @Override
    default public Element removeStereotype(String annotationType) {
        return (Element)MutableAnnotationMetadataDelegate.super.removeStereotype(annotationType);
    }

    @Override
    default public <T extends Annotation> Element removeStereotype(Class<T> annotationType) {
        return (Element)MutableAnnotationMetadataDelegate.super.removeStereotype(annotationType);
    }

    @Override
    default public Element annotate(String annotationType) {
        return (Element)MutableAnnotationMetadataDelegate.super.annotate(annotationType);
    }

    @Override
    default public <T extends Annotation> Element annotate(Class<T> annotationType, Consumer<AnnotationValueBuilder<T>> consumer) {
        return (Element)MutableAnnotationMetadataDelegate.super.annotate(annotationType, consumer);
    }

    @Override
    default public <T extends Annotation> Element annotate(Class<T> annotationType) {
        return (Element)MutableAnnotationMetadataDelegate.super.annotate(annotationType);
    }

    @Override
    default public <T extends Annotation> Element annotate(AnnotationValue<T> annotationValue) {
        return (Element)MutableAnnotationMetadataDelegate.super.annotate(annotationValue);
    }
}

