/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Optional;

public interface PropertyElement
extends TypedElement,
MemberElement {
    @Override
    @NonNull
    public ClassElement getType();

    default public boolean isExcluded() {
        return false;
    }

    default public boolean isReadOnly() {
        return this.getWriteMember().isEmpty();
    }

    default public boolean isWriteOnly() {
        return this.getReadMember().isEmpty();
    }

    default public Optional<FieldElement> getField() {
        return Optional.empty();
    }

    default public Optional<MethodElement> getWriteMethod() {
        return Optional.empty();
    }

    default public Optional<MethodElement> getReadMethod() {
        return Optional.empty();
    }

    default public Optional<? extends MemberElement> getReadMember() {
        if (this.getReadAccessKind() == AccessKind.METHOD) {
            return this.getReadMethod();
        }
        return this.getField();
    }

    default public Optional<? extends MemberElement> getWriteMember() {
        if (this.getWriteAccessKind() == AccessKind.METHOD) {
            return this.getWriteMethod();
        }
        return this.getField();
    }

    default public AccessKind getReadAccessKind() {
        return AccessKind.METHOD;
    }

    default public AccessKind getWriteAccessKind() {
        return AccessKind.METHOD;
    }

    default public boolean overrides(PropertyElement overridden) {
        return false;
    }

    public static enum AccessKind {
        FIELD,
        METHOD;

    }
}

