/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class AbstractElementAnnotationMetadataFactory<K, A>
implements ElementAnnotationMetadataFactory {
    protected final boolean isReadOnly;
    protected final AbstractAnnotationMetadataBuilder<K, A> metadataBuilder;

    protected AbstractElementAnnotationMetadataFactory(boolean isReadOnly, AbstractAnnotationMetadataBuilder<K, A> metadataBuilder) {
        this.isReadOnly = isReadOnly;
        this.metadataBuilder = metadataBuilder;
    }

    @Override
    public ElementAnnotationMetadata build(Element element) {
        if (element instanceof ClassElement) {
            ClassElement classElement = (ClassElement)element;
            return this.buildForClass(classElement);
        }
        if (element instanceof ConstructorElement) {
            ConstructorElement constructorElement = (ConstructorElement)element;
            return this.buildForConstructor(constructorElement);
        }
        if (element instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)element;
            return this.buildForMethod(methodElement);
        }
        if (element instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)element;
            return this.buildForField(fieldElement);
        }
        if (element instanceof ParameterElement) {
            ParameterElement parameterElement = (ParameterElement)element;
            return this.buildForParameter(parameterElement);
        }
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            return this.buildForPackage(packageElement);
        }
        if (element instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)element;
            return this.buildForProperty(propertyElement);
        }
        if (element instanceof EnumConstantElement) {
            EnumConstantElement enumConstantElement = (EnumConstantElement)element;
            return this.buildForEnumConstantElement(enumConstantElement);
        }
        throw new IllegalStateException("Unknown element: " + element.getClass() + " with native type: " + element.getNativeType());
    }

    @Override
    public ElementAnnotationMetadata buildMutable(final AnnotationMetadata originalAnnotationMetadata) {
        if (originalAnnotationMetadata instanceof AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata) {
            throw new IllegalStateException();
        }
        if (originalAnnotationMetadata instanceof ElementAnnotationMetadata) {
            throw new IllegalStateException("Not supported element annotation metadata: " + originalAnnotationMetadata);
        }
        return new MutableElementAnnotationMetadata(){
            private AnnotationMetadata thisAnnotationMetadata;
            {
                this.thisAnnotationMetadata = originalAnnotationMetadata;
            }

            public AnnotationMetadata getAnnotationMetadata() {
                return this.thisAnnotationMetadata;
            }

            @Override
            protected AnnotationMetadata getAnnotationMetadataToModify() {
                return this.thisAnnotationMetadata;
            }

            @Override
            protected AnnotationMetadata replaceAnnotationsInternal(AnnotationMetadata annotationMetadata) {
                this.thisAnnotationMetadata = annotationMetadata;
                return this.thisAnnotationMetadata;
            }
        };
    }

    @Override
    public ElementAnnotationMetadata buildTypeAnnotations(ClassElement element) {
        return this.buildTypeAnnotationsForClass(element);
    }

    @Override
    public ElementAnnotationMetadata buildGenericTypeAnnotations(GenericElement element) {
        if (element instanceof GenericPlaceholderElement) {
            GenericPlaceholderElement placeholderElement = (GenericPlaceholderElement)element;
            return this.buildTypeAnnotationsForGenericPlaceholder(placeholderElement);
        }
        if (element instanceof WildcardElement) {
            WildcardElement wildcardElement = (WildcardElement)element;
            return this.buildTypeAnnotationsForWildcard(wildcardElement);
        }
        throw new IllegalStateException("Unknown generic element: " + element.getClass() + " with native type: " + element.getNativeType());
    }

    protected K getNativeElement(Element element) {
        return (K)element.getNativeType();
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupForPackage(PackageElement packageElement) {
        return this.metadataBuilder.lookupOrBuildForType(this.getNativeElement(packageElement));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupForParameter(ParameterElement parameterElement) {
        return this.metadataBuilder.lookupOrBuildForParameter(this.getNativeElement(parameterElement.getMethodElement().getOwningType()), this.getNativeElement(parameterElement.getMethodElement()), this.getNativeElement(parameterElement));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupForField(FieldElement fieldElement) {
        return this.metadataBuilder.lookupOrBuildForField(this.getNativeElement(fieldElement.getOwningType()), this.getNativeElement(fieldElement));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupForMethod(MethodElement methodElement) {
        return this.metadataBuilder.lookupOrBuildForMethod(this.getNativeElement(methodElement.getOwningType()), this.getNativeElement(methodElement));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupForClass(ClassElement classElement) {
        return this.metadataBuilder.lookupOrBuildForType(this.getNativeElement(classElement));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForClass(final ClassElement classElement) {
        return new AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata(){

            @Override
            public AnnotationMetadata getAnnotationMetadata() {
                return AnnotationMetadata.EMPTY_METADATA;
            }

            @Override
            public boolean isMutated() {
                return false;
            }

            @Override
            public void update(AnnotationMetadata annotationMetadata) {
                throw new IllegalStateException("Class element: [" + classElement + "] doesn't support type annotations!");
            }
        };
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForGenericPlaceholder(GenericPlaceholderElement placeholderElement) {
        return this.metadataBuilder.lookupOrBuildForType(this.getNativeElement(placeholderElement));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForWildcard(WildcardElement wildcardElement) {
        return this.metadataBuilder.lookupOrBuildForType(this.getNativeElement(wildcardElement));
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildForProperty(final @NonNull PropertyElement propertyElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                throw new IllegalStateException("Properties should combine annotations for it's elements!");
            }

            public String toString() {
                return propertyElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildForEnumConstantElement(final @NonNull EnumConstantElement enumConstantElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupForField(enumConstantElement);
            }

            public String toString() {
                return enumConstantElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildForPackage(final @NonNull PackageElement packageElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupForPackage(packageElement);
            }

            public String toString() {
                return packageElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildForParameter(final @NonNull ParameterElement parameterElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupForParameter(parameterElement);
            }

            public String toString() {
                return parameterElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildForField(final @NonNull FieldElement fieldElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupForField(fieldElement);
            }

            public String toString() {
                return fieldElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildForMethod(final @NonNull MethodElement methodElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupForMethod(methodElement);
            }

            public String toString() {
                return methodElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildForConstructor(final @NonNull ConstructorElement constructorElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupForMethod(constructorElement);
            }

            public String toString() {
                return constructorElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildTypeAnnotationsForClass(final @NonNull ClassElement classElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupTypeAnnotationsForClass(classElement);
            }

            public String toString() {
                return classElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildForClass(final @NonNull ClassElement classElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupForClass(classElement);
            }

            public String toString() {
                return classElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildTypeAnnotationsForGenericPlaceholder(final @NonNull GenericPlaceholderElement placeholderElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupTypeAnnotationsForGenericPlaceholder(placeholderElement);
            }

            public String toString() {
                return placeholderElement.toString();
            }
        };
    }

    @NonNull
    private AbstractElementAnnotationMetadata buildTypeAnnotationsForWildcard(final @NonNull WildcardElement wildcardElement) {
        return new AbstractElementAnnotationMetadata(){

            @Override
            protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup() {
                return AbstractElementAnnotationMetadataFactory.this.lookupTypeAnnotationsForWildcard(wildcardElement);
            }

            public String toString() {
                return wildcardElement.toString();
            }
        };
    }

    protected abstract class AbstractElementAnnotationMetadata
    extends MutableElementAnnotationMetadata {
        private final boolean readOnly;
        private AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata cacheEntry;
        private AnnotationMetadata annotationMetadata;

        protected AbstractElementAnnotationMetadata() {
            this(this$0.isReadOnly);
        }

        protected AbstractElementAnnotationMetadata(boolean readOnly) {
            this.readOnly = readOnly;
        }

        protected abstract AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookup();

        private AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata getCacheEntry() {
            if (this.cacheEntry == null) {
                this.cacheEntry = this.lookup();
            }
            return this.cacheEntry;
        }

        public AnnotationMetadata getAnnotationMetadata() {
            if (this.annotationMetadata != null) {
                return this.annotationMetadata;
            }
            return this.getCacheEntry();
        }

        @Override
        protected AnnotationMetadata getAnnotationMetadataToModify() {
            if (this.annotationMetadata != null) {
                return this.annotationMetadata;
            }
            return this.getCacheEntry().copyAnnotationMetadata();
        }

        @Override
        protected AnnotationMetadata replaceAnnotationsInternal(AnnotationMetadata annotationMetadata) {
            if (annotationMetadata instanceof AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata) {
                throw new IllegalStateException();
            }
            if (annotationMetadata instanceof MutableAnnotationMetadataDelegate) {
                throw new IllegalStateException();
            }
            if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
                throw new IllegalStateException("Not supported to cache AnnotationMetadataHierarchy");
            }
            if (annotationMetadata.isEmpty()) {
                annotationMetadata = EMPTY_METADATA;
            }
            if (this.readOnly) {
                this.annotationMetadata = annotationMetadata;
            } else {
                this.getCacheEntry().update(annotationMetadata);
            }
            return this.getAnnotationMetadata();
        }
    }

    protected abstract class MutableElementAnnotationMetadata
    implements ElementAnnotationMetadata {
        protected MutableElementAnnotationMetadata() {
        }

        protected abstract AnnotationMetadata getAnnotationMetadataToModify();

        protected abstract AnnotationMetadata replaceAnnotationsInternal(AnnotationMetadata var1);

        @Override
        public <T extends Annotation> AnnotationMetadata annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
            ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
            AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType, (RetentionPolicy)AbstractElementAnnotationMetadataFactory.this.metadataBuilder.getRetentionPolicy(annotationType));
            if (consumer != null) {
                consumer.accept(builder);
                AnnotationValue av = builder.build();
                return this.replaceAnnotationsInternal(AbstractElementAnnotationMetadataFactory.this.metadataBuilder.annotate(this.getAnnotationMetadataToModify(), av));
            }
            return this.getAnnotationMetadata();
        }

        @Override
        public <T extends Annotation> AnnotationMetadata annotate(AnnotationValue<T> annotationValue) {
            ArgumentUtils.requireNonNull((String)"annotationValue", annotationValue);
            return this.replaceAnnotationsInternal(AbstractElementAnnotationMetadataFactory.this.metadataBuilder.annotate(this.getAnnotationMetadataToModify(), annotationValue));
        }

        @Override
        public AnnotationMetadata removeAnnotation(@NonNull String annotationType) {
            ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
            return this.replaceAnnotationsInternal(AbstractElementAnnotationMetadataFactory.this.metadataBuilder.removeAnnotation(this.getAnnotationMetadataToModify(), annotationType));
        }

        @Override
        public <T extends Annotation> AnnotationMetadata removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
            ArgumentUtils.requireNonNull((String)"predicate", predicate);
            return this.replaceAnnotationsInternal(AbstractElementAnnotationMetadataFactory.this.metadataBuilder.removeAnnotationIf(this.getAnnotationMetadataToModify(), predicate));
        }

        @Override
        public AnnotationMetadata removeStereotype(@NonNull String annotationType) {
            ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
            return this.replaceAnnotationsInternal(AbstractElementAnnotationMetadataFactory.this.metadataBuilder.removeStereotype(this.getAnnotationMetadataToModify(), annotationType));
        }
    }
}

