/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.annotation;

import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface MutableAnnotationMetadataDelegate<R>
extends AnnotationMetadataDelegate {
    public static final MutableAnnotationMetadataDelegate<?> EMPTY = new MutableAnnotationMetadataDelegate<Object>(){};

    @NonNull
    default public <T extends Annotation> R annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support adding annotations at compilation time");
    }

    @NonNull
    default public R removeAnnotation(@NonNull String annotationType) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support removing annotations at compilation time");
    }

    @NonNull
    default public <T extends Annotation> R removeAnnotation(@NonNull Class<T> annotationType) {
        return this.removeAnnotation(Objects.requireNonNull(annotationType).getName());
    }

    @NonNull
    default public <T extends Annotation> R removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support removing annotations at compilation time");
    }

    @NonNull
    default public R removeStereotype(@NonNull String annotationType) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support removing annotations at compilation time");
    }

    @NonNull
    default public <T extends Annotation> R removeStereotype(@NonNull Class<T> annotationType) {
        return this.removeStereotype(Objects.requireNonNull(annotationType).getName());
    }

    @NonNull
    default public R annotate(@NonNull String annotationType) {
        return this.annotate(annotationType, (AnnotationValueBuilder<T> annotationValueBuilder) -> {});
    }

    @NonNull
    default public <T extends Annotation> R annotate(@NonNull Class<T> annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        ArgumentUtils.requireNonNull((String)"consumer", consumer);
        return this.annotate(annotationType.getName(), consumer);
    }

    @NonNull
    default public <T extends Annotation> R annotate(@NonNull Class<T> annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        return this.annotate(annotationType.getName(), (AnnotationValueBuilder<T> annotationValueBuilder) -> {});
    }

    @NonNull
    default public <T extends Annotation> R annotate(@NonNull AnnotationValue<T> annotationValue) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support adding annotations at compilation time");
    }
}

