/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class PropertyElementAnnotationMetadata
implements ElementAnnotationMetadata {
    private final Element thisElement;
    private final List<MutableAnnotationMetadataDelegate<?>> elements;
    private final AnnotationMetadata propertyAnnotationMetadata;

    public PropertyElementAnnotationMetadata(@NonNull Element thisElement, @Nullable MethodElement getter, @Nullable MethodElement setter, @Nullable FieldElement field, @Nullable ParameterElement constructorParameter, boolean includeSynthetic) {
        AnnotationMetadata[] hierarchy;
        MutableAnnotationMetadataDelegate<AnnotationMetadata> typeAnnotationMetadata;
        this.thisElement = thisElement;
        ArrayList elements = new ArrayList(3);
        if (setter != null && (!setter.isSynthetic() || includeSynthetic)) {
            ParameterElement parameter;
            MutableAnnotationMetadataDelegate<AnnotationMetadata> typeAnnotationMetadata2;
            elements.add(setter.getMethodAnnotationMetadata());
            ParameterElement[] parameters = setter.getParameters();
            if (parameters.length > 0 && !(typeAnnotationMetadata2 = (parameter = parameters[0]).getType().getTypeAnnotationMetadata()).isEmpty()) {
                elements.add(typeAnnotationMetadata2);
            }
        }
        if (constructorParameter != null) {
            elements.add(constructorParameter);
            typeAnnotationMetadata = constructorParameter.getType().getTypeAnnotationMetadata();
            if (!typeAnnotationMetadata.isEmpty()) {
                elements.add(typeAnnotationMetadata);
            }
        }
        if (field != null && (!field.isSynthetic() || includeSynthetic)) {
            ClassElement genericFieldType = field.getGenericType();
            if (getter != null && getter.getGenericReturnType().isAssignable(Optional.class) && !genericFieldType.isAssignable(Optional.class)) {
                ClassElement wrappedArgument = getter.getGenericReturnType().getTypeArguments(Optional.class).get("T");
                if (wrappedArgument != null) {
                    AnnotationMetadata wrappedArgumentAnnotationMetadata = wrappedArgument.getTargetAnnotationMetadata();
                    AnnotationMetadata fieldAnnotationMetadata = genericFieldType.getAnnotationMetadata().getTargetAnnotationMetadata();
                    if (wrappedArgumentAnnotationMetadata instanceof MutableAnnotationMetadata) {
                        MutableAnnotationMetadata mutableAnnotationMetadata = (MutableAnnotationMetadata)wrappedArgumentAnnotationMetadata;
                        if (fieldAnnotationMetadata instanceof MutableAnnotationMetadata) {
                            MutableAnnotationMetadata fieldMutableAnnotationMetadata = (MutableAnnotationMetadata)fieldAnnotationMetadata;
                            mutableAnnotationMetadata.addAnnotationMetadata(fieldMutableAnnotationMetadata);
                        }
                    }
                }
            } else {
                elements.add(field);
                MutableAnnotationMetadataDelegate<AnnotationMetadata> typeAnnotationMetadata3 = field.getType().getTypeAnnotationMetadata();
                if (!typeAnnotationMetadata3.isEmpty()) {
                    elements.add(typeAnnotationMetadata3);
                }
            }
        }
        if (getter != null && (!getter.isSynthetic() || includeSynthetic)) {
            elements.add(getter.getMethodAnnotationMetadata());
            typeAnnotationMetadata = getter.getReturnType().getTypeAnnotationMetadata();
            if (!typeAnnotationMetadata.isEmpty()) {
                elements.add(typeAnnotationMetadata);
            }
        }
        this.propertyAnnotationMetadata = (hierarchy = (AnnotationMetadata[])elements.toArray(AnnotationMetadata[]::new)).length == 1 ? hierarchy[0] : new AnnotationMetadataHierarchy(true, hierarchy);
        this.elements = elements;
    }

    @Override
    public <T extends Annotation> Element annotate(AnnotationValue<T> annotationValue) {
        for (MutableAnnotationMetadataDelegate<?> am : this.elements) {
            am.annotate(annotationValue);
        }
        return this.thisElement;
    }

    @Override
    public <T extends Annotation> Element annotate(String annotationType, Consumer<AnnotationValueBuilder<T>> consumer) {
        for (MutableAnnotationMetadataDelegate<?> am : this.elements) {
            am.annotate(annotationType, consumer);
        }
        return this.thisElement;
    }

    @Override
    public <T extends Annotation> Element annotate(Class<T> annotationType) {
        for (MutableAnnotationMetadataDelegate<?> am : this.elements) {
            am.annotate(annotationType);
        }
        return this.thisElement;
    }

    @Override
    public Element annotate(String annotationType) {
        for (MutableAnnotationMetadataDelegate<?> am : this.elements) {
            am.annotate(annotationType);
        }
        return this.thisElement;
    }

    @Override
    public <T extends Annotation> Element annotate(Class<T> annotationType, Consumer<AnnotationValueBuilder<T>> consumer) {
        for (MutableAnnotationMetadataDelegate<?> am : this.elements) {
            am.annotate(annotationType, consumer);
        }
        return this.thisElement;
    }

    @Override
    public Element removeAnnotation(String annotationType) {
        for (MutableAnnotationMetadataDelegate<?> am : this.elements) {
            am.removeAnnotation(annotationType);
        }
        return this.thisElement;
    }

    @Override
    public <T extends Annotation> Element removeAnnotationIf(Predicate<AnnotationValue<T>> predicate) {
        for (MutableAnnotationMetadataDelegate<?> am : this.elements) {
            am.removeAnnotationIf(predicate);
        }
        return this.thisElement;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.propertyAnnotationMetadata;
    }
}

