/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import io.micronaut.context.annotation.BeanProperties;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.annotation.TypedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

@Internal
public final class IntrospectedToBeanPropertiesTransformer
implements TypedAnnotationTransformer<Introspected> {
    @Override
    public List<AnnotationValue<?>> transform(AnnotationValue<Introspected> annotation, VisitorContext visitorContext) {
        Object[] accessKinds = (Introspected.AccessKind[])annotation.enumValues("accessKind", Introspected.AccessKind.class);
        Object[] visibilities = (Introspected.Visibility[])annotation.enumValues("visibility", Introspected.Visibility.class);
        if (ArrayUtils.isEmpty((Object[])accessKinds)) {
            accessKinds = Introspected.DEFAULT_ACCESS_KIND;
        }
        if (ArrayUtils.isEmpty((Object[])visibilities)) {
            visibilities = Introspected.DEFAULT_VISIBILITY;
        }
        return Arrays.asList(annotation, AnnotationValue.builder((String)BeanProperties.class.getName(), (RetentionPolicy)RetentionPolicy.CLASS).member("accessKind", (Enum[])accessKinds).member("visibility", (Enum[])visibilities).member("includes", annotation.stringValues("includes")).member("excludes", annotation.stringValues("excludes")).member("excludedAnnotations", annotation.stringValues("excludedAnnotations")).build());
    }

    @Override
    public Class<Introspected> annotationType() {
        return Introspected.class;
    }
}

