/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.configuration;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocSnippet;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationUtils;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.writer.OriginatingElements;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConfigurationMetadataBuilder {
    public static final ConfigurationMetadataBuilder INSTANCE = new ConfigurationMetadataBuilder();
    private final OriginatingElements originatingElements = OriginatingElements.of(new Element[0]);
    private final List<PropertyMetadata> properties = new ArrayList<PropertyMetadata>();
    private final List<ConfigurationMetadata> configurations = new ArrayList<ConfigurationMetadata>();

    @NonNull
    public Element[] getOriginatingElements() {
        return this.originatingElements.getOriginatingElements();
    }

    public List<PropertyMetadata> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public List<ConfigurationMetadata> getConfigurations() {
        return Collections.unmodifiableList(this.configurations);
    }

    public boolean hasMetadata() {
        return !this.properties.isEmpty() || !this.configurations.isEmpty();
    }

    public ConfigurationMetadata visitProperties(ClassElement classElement) {
        this.originatingElements.addOriginatingElement(classElement);
        String path = ConfigurationUtils.getRequiredTypePath(classElement);
        ConfigurationMetadata configurationMetadata = new ConfigurationMetadata();
        configurationMetadata.name = NameUtils.hyphenate((String)path, (boolean)true);
        configurationMetadata.type = classElement.getType().getName();
        configurationMetadata.description = ConfigurationMetadataBuilder.resolveJavadocDescription(classElement);
        configurationMetadata.includes = CollectionUtils.setOf((Object[])classElement.stringValues(ConfigurationReader.class, "includes"));
        configurationMetadata.excludes = CollectionUtils.setOf((Object[])classElement.stringValues(ConfigurationReader.class, "excludes"));
        this.configurations.add(configurationMetadata);
        return configurationMetadata;
    }

    @Nullable
    public static String resolveJavadocDescription(@NonNull Element element) {
        String resolvedDocs = null;
        String javadoc = element.getDocumentation().orElse(null);
        if (javadoc == null && element instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)element;
            javadoc = propertyElement.getWriteMethod().flatMap(Element::getDocumentation).orElse(null);
        }
        if (javadoc != null) {
            try {
                Javadoc jd = StaticJavaParser.parseJavadoc((String)javadoc);
                JavadocDescription description = jd.getDescription();
                StringBuilder builder = new StringBuilder();
                List elements = description.getElements();
                if (!elements.isEmpty()) {
                    for (JavadocDescriptionElement jde : elements) {
                        if (!(jde instanceof JavadocSnippet)) continue;
                        JavadocSnippet snippet = (JavadocSnippet)jde;
                        builder.append(snippet.toText());
                    }
                } else if (element instanceof MethodElement) {
                    jd.getBlockTags().stream().filter(bt -> bt.getType() == JavadocBlockTag.Type.RETURN).findFirst().ifPresent(returnTag -> builder.append(returnTag.getContent().toText()));
                } else if (element instanceof PropertyElement) {
                    jd.getBlockTags().stream().filter(bt -> bt.getType() == JavadocBlockTag.Type.PARAM).findFirst().ifPresent(returnTag -> builder.append(returnTag.getContent().toText()));
                }
                resolvedDocs = builder.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resolvedDocs;
    }

    public PropertyMetadata visitProperty(ClassElement owningType, ClassElement declaringType, ClassElement propertyType, String name, @Nullable String description, @Nullable String defaultValue) {
        this.originatingElements.addOriginatingElement(owningType);
        this.originatingElements.addOriginatingElement(declaringType);
        PropertyMetadata metadata = new PropertyMetadata();
        metadata.declaringType = declaringType.getName();
        metadata.name = name;
        metadata.path = NameUtils.hyphenate((String)ConfigurationUtils.buildPropertyPath(owningType, declaringType, name), (boolean)true);
        metadata.type = propertyType.getType().getName();
        metadata.description = description;
        metadata.defaultValue = defaultValue;
        this.properties.add(metadata);
        return metadata;
    }

    static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block8: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    static void writeAttribute(Writer out, String name, String value) throws IOException {
        out.write(34);
        out.write(name);
        out.write("\":");
        out.write(ConfigurationMetadataBuilder.quote(value));
    }

    @Internal
    public static void reset() {
        ConfigurationMetadataBuilder.INSTANCE.properties.clear();
        ConfigurationMetadataBuilder.INSTANCE.configurations.clear();
    }
}

