/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.configuration;

import io.micronaut.core.io.Writable;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.ConfigurationMetadataWriter;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class JsonConfigurationMetadataWriter
implements ConfigurationMetadataWriter {
    @Override
    public void write(ConfigurationMetadataBuilder metadataBuilder, ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        Optional<GeneratedFile> opt = classWriterOutputVisitor.visitMetaInfFile(this.getFileName(), metadataBuilder.getOriginatingElements());
        if (opt.isPresent()) {
            GeneratedFile file = opt.get();
            List<ConfigurationMetadata> configurations = metadataBuilder.getConfigurations();
            List<PropertyMetadata> properties = metadataBuilder.getProperties();
            try (Writer writer = file.openWriter();){
                boolean hasProps;
                writer.write(123);
                boolean hasGroups = !configurations.isEmpty();
                boolean bl = hasProps = !properties.isEmpty();
                if (hasGroups) {
                    this.writeMetadata("groups", configurations, writer);
                    if (hasProps) {
                        writer.write(44);
                    }
                }
                if (hasProps) {
                    this.writeMetadata("properties", properties, writer);
                }
                writer.write(125);
            }
        }
    }

    protected String getFileName() {
        return "spring-configuration-metadata.json";
    }

    private void writeMetadata(String attr, List<? extends Writable> configurations, Writer writer) throws IOException {
        writer.write(34);
        writer.write(attr);
        writer.write("\":[");
        Iterator<? extends Writable> i = configurations.iterator();
        while (i.hasNext()) {
            Writable metadata = i.next();
            metadata.writeTo(writer);
            if (!i.hasNext()) continue;
            writer.write(44);
        }
        writer.write(93);
    }
}

