/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.BeanDefinitionCreator;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.validation.RequiresValidation;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

@Internal
abstract class AbstractBeanElementCreator
implements BeanDefinitionCreator {
    public static final String ANN_VALIDATED = "io.micronaut.validation.Validated";
    protected static final String ANN_REQUIRES_VALIDATION = RequiresValidation.class.getName();
    protected final ClassElement classElement;
    protected final VisitorContext visitorContext;
    protected final List<BeanDefinitionVisitor> beanDefinitionWriters = new LinkedList<BeanDefinitionVisitor>();

    protected AbstractBeanElementCreator(ClassElement classElement, VisitorContext visitorContext) {
        this.classElement = classElement;
        this.visitorContext = visitorContext;
        this.checkPackage(classElement);
    }

    @Override
    public final Collection<BeanDefinitionVisitor> build() {
        this.buildInternal();
        return this.beanDefinitionWriters;
    }

    protected abstract void buildInternal();

    private void checkPackage(ClassElement classElement) {
        PackageElement packageElement = classElement.getPackage();
        if (packageElement.isUnnamed()) {
            throw new ProcessingException(classElement, "Micronaut beans cannot be in the default package");
        }
    }

    protected void visitAnnotationMetadata(BeanDefinitionVisitor writer, AnnotationMetadata annotationMetadata) {
        for (AnnotationValue annotation : annotationMetadata.getAnnotationValuesByType(Requires.class)) {
            annotation.stringValue("beanProperty").ifPresent(beanProperty -> annotation.stringValue("bean").flatMap(className -> this.visitorContext.getClassElement((String)className, this.visitorContext.getElementAnnotationMetadataFactory().readOnly())).ifPresent(classElement -> {
                String requiredValue = annotation.stringValue().orElse(null);
                String notEqualsValue = annotation.stringValue("notEquals").orElse(null);
                writer.visitAnnotationMemberPropertyInjectionPoint((TypedElement)classElement, (String)beanProperty, requiredValue, notEqualsValue);
            }));
        }
    }

    public static AnnotationMetadata getElementAnnotationMetadata(MemberElement memberElement) {
        if (memberElement instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)memberElement;
            return methodElement.getMethodAnnotationMetadata();
        }
        return memberElement.getAnnotationMetadata();
    }

    protected boolean visitIntrospectedMethod(BeanDefinitionVisitor visitor, ClassElement typeElement, MethodElement methodElement) {
        AopProxyWriter aopProxyWriter = (AopProxyWriter)visitor;
        AnnotationMetadata resolvedTypeMetadata = typeElement.getAnnotationMetadata();
        boolean resolvedTypeMetadataIsAopProxyType = InterceptedMethodUtil.hasDeclaredAroundAdvice((AnnotationMetadata)resolvedTypeMetadata);
        if (methodElement.isAbstract() || resolvedTypeMetadataIsAopProxyType || InterceptedMethodUtil.hasDeclaredAroundAdvice((AnnotationMetadata)methodElement.getAnnotationMetadata())) {
            AbstractBeanElementCreator.addToIntroduction(aopProxyWriter, typeElement, methodElement, false);
            return true;
        }
        if (!methodElement.isAbstract() && methodElement.hasDeclaredStereotype(Executable.class)) {
            aopProxyWriter.visitExecutableMethod(typeElement, methodElement, this.visitorContext);
        }
        return false;
    }

    protected static void addToIntroduction(AopProxyWriter aopProxyWriter, ClassElement classElement, MethodElement methodElement, boolean ignoreNotAbstract) {
        AnnotationMetadata methodAnnotationMetadata = methodElement.getDeclaredMetadata();
        if (InterceptedMethodUtil.hasAroundStereotype((AnnotationMetadata)methodAnnotationMetadata)) {
            aopProxyWriter.visitInterceptorBinding(InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)methodAnnotationMetadata, (InterceptorKind)InterceptorKind.AROUND));
        }
        if (!classElement.getName().equals(methodElement.getDeclaringType().getName())) {
            aopProxyWriter.addOriginatingElement(methodElement.getDeclaringType());
        }
        ClassElement declaringType = methodElement.getDeclaringType();
        if (methodElement.isAbstract()) {
            aopProxyWriter.visitIntroductionMethod(declaringType, methodElement);
        } else if (!ignoreNotAbstract) {
            boolean isInterface = methodElement.getDeclaringType().isInterface();
            boolean isDefault = methodElement.isDefault();
            if (isInterface && isDefault) {
                declaringType = classElement;
            }
            aopProxyWriter.visitAroundMethod(declaringType, methodElement);
        }
    }

    protected AopProxyWriter createAroundAopProxyWriter(BeanDefinitionVisitor existingWriter, AnnotationMetadata aopElementAnnotationProcessor, VisitorContext visitorContext, boolean forceProxyTarget) {
        OptionalValues aroundSettings = aopElementAnnotationProcessor.getValues("io.micronaut.aop.Around", Boolean.class);
        LinkedHashMap<CharSequence, Boolean> settings = new LinkedHashMap<CharSequence, Boolean>();
        for (CharSequence setting : aroundSettings) {
            Optional entry = aroundSettings.get(setting);
            entry.ifPresent(val -> settings.put(setting, (Boolean)val));
        }
        if (forceProxyTarget) {
            settings.put(Interceptor.PROXY_TARGET, true);
        }
        aroundSettings = OptionalValues.of(Boolean.class, settings);
        return new AopProxyWriter((BeanDefinitionWriter)existingWriter, (OptionalValues<Boolean>)aroundSettings, visitorContext, InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)aopElementAnnotationProcessor, (InterceptorKind)InterceptorKind.AROUND));
    }

    protected AopProxyWriter createIntroductionAopProxyWriter(ClassElement typeElement, VisitorContext visitorContext) {
        AnnotationMetadata annotationMetadata = typeElement.getAnnotationMetadata();
        String packageName = typeElement.getPackageName();
        String beanClassName = typeElement.getSimpleName();
        Object[] aroundInterceptors = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)annotationMetadata, (InterceptorKind)InterceptorKind.AROUND);
        Object[] introductionInterceptors = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)annotationMetadata, (InterceptorKind)InterceptorKind.INTRODUCTION);
        ClassElement[] interfaceTypes = (ClassElement[])Arrays.stream(annotationMetadata.getValue(Introduction.class, "interfaces", String[].class).orElse(new String[0])).map(v -> visitorContext.getClassElement((String)v, visitorContext.getElementAnnotationMetadataFactory().readOnly()).orElseThrow(() -> new ProcessingException(typeElement, "Cannot find interface: " + v))).toArray(ClassElement[]::new);
        AnnotationValue[] interceptorTypes = (AnnotationValue[])ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
        boolean isInterface = typeElement.isInterface();
        AopProxyWriter aopProxyWriter = new AopProxyWriter(packageName, beanClassName, isInterface, (Element)typeElement, annotationMetadata, interfaceTypes, visitorContext, interceptorTypes);
        Arrays.stream(interfaceTypes).flatMap(interfaceElement -> interfaceElement.getEnclosedElements(ElementQuery.ALL_METHODS).stream()).forEach(methodElement -> AbstractBeanElementCreator.addToIntroduction(aopProxyWriter, typeElement, methodElement.withNewOwningType(typeElement), true));
        return aopProxyWriter;
    }
}

