/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.processing.DeclaredBeanElementCreator;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.BeanDefinitionVisitor;

@Internal
final class AopIntroductionProxySupportedBeanElementCreator
extends DeclaredBeanElementCreator {
    AopIntroductionProxySupportedBeanElementCreator(ClassElement classElement, VisitorContext visitorContext, boolean isAopProxy) {
        super(classElement, visitorContext, isAopProxy);
    }

    @Override
    protected BeanDefinitionVisitor createBeanDefinitionVisitor() {
        if (this.classElement.isFinal()) {
            throw new ProcessingException(this.classElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + this.classElement.getName());
        }
        this.aopProxyVisitor = this.createIntroductionAopProxyWriter(this.classElement, this.visitorContext);
        this.beanDefinitionWriters.add(this.aopProxyVisitor);
        MethodElement constructorElement = this.classElement.getPrimaryConstructor().orElse(null);
        if (constructorElement != null) {
            this.aopProxyVisitor.visitBeanDefinitionConstructor(constructorElement, constructorElement.isPrivate(), this.visitorContext);
        } else {
            this.aopProxyVisitor.visitDefaultConstructor(AnnotationMetadata.EMPTY_METADATA, this.visitorContext);
        }
        return this.aopProxyVisitor;
    }

    @Override
    protected AopProxyWriter getAroundAopProxyVisitor(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        return this.aopProxyVisitor;
    }

    @Override
    protected boolean visitPropertyReadElement(BeanDefinitionVisitor visitor, PropertyElement propertyElement, MethodElement readElement) {
        if (readElement.isAbstract() && this.visitIntrospectedMethod(visitor, this.classElement, readElement)) {
            return true;
        }
        return super.visitPropertyReadElement(visitor, propertyElement, readElement);
    }

    @Override
    protected boolean visitPropertyWriteElement(BeanDefinitionVisitor visitor, PropertyElement propertyElement, MethodElement writeElement) {
        if (writeElement.isAbstract() && this.visitIntrospectedMethod(visitor, this.classElement, writeElement)) {
            return true;
        }
        return super.visitPropertyWriteElement(visitor, propertyElement, writeElement);
    }

    @Override
    protected boolean visitMethod(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        if (methodElement.isAbstract() && this.visitIntrospectedMethod(visitor, this.classElement, methodElement)) {
            return true;
        }
        return super.visitMethod(visitor, methodElement);
    }
}

