/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Vetoed;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.processing.AbstractBeanElementCreator;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
class DeclaredBeanElementCreator
extends AbstractBeanElementCreator {
    private static final String MSG_ADAPTER_METHOD_PREFIX = "Cannot adapt method [";
    private static final String MSG_TARGET_METHOD_PREFIX = "] to target method [";
    protected AopProxyWriter aopProxyVisitor;
    protected final boolean isAopProxy;
    private final AtomicInteger adaptedMethodIndex = new AtomicInteger(0);

    protected DeclaredBeanElementCreator(ClassElement classElement, VisitorContext visitorContext, boolean isAopProxy) {
        super(classElement, visitorContext);
        this.isAopProxy = isAopProxy;
    }

    @Override
    public final void buildInternal() {
        BeanDefinitionVisitor beanDefinitionVisitor = this.createBeanDefinitionVisitor();
        if (this.isAopProxy) {
            this.getAroundAopProxyVisitor(beanDefinitionVisitor, null);
        }
        this.build(beanDefinitionVisitor);
    }

    @NonNull
    protected BeanDefinitionVisitor createBeanDefinitionVisitor() {
        BeanDefinitionWriter beanDefinitionWriter = new BeanDefinitionWriter(this.classElement, this.visitorContext);
        this.beanDefinitionWriters.add(beanDefinitionWriter);
        beanDefinitionWriter.visitTypeArguments(this.classElement.getAllTypeArguments());
        this.visitAnnotationMetadata(beanDefinitionWriter, this.classElement.getAnnotationMetadata());
        MethodElement constructorElement = this.classElement.getPrimaryConstructor().orElse(null);
        if (constructorElement != null) {
            this.applyConfigurationInjectionIfNecessary(beanDefinitionWriter, constructorElement);
            beanDefinitionWriter.visitBeanDefinitionConstructor(constructorElement, constructorElement.isPrivate(), this.visitorContext);
        } else {
            beanDefinitionWriter.visitDefaultConstructor(AnnotationMetadata.EMPTY_METADATA, this.visitorContext);
        }
        return beanDefinitionWriter;
    }

    protected AopProxyWriter getAroundAopProxyVisitor(BeanDefinitionVisitor visitor, @Nullable MethodElement methodElement) {
        if (this.aopProxyVisitor == null) {
            if (this.classElement.isFinal()) {
                throw new ProcessingException(this.classElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + this.classElement.getName());
            }
            this.aopProxyVisitor = this.createAroundAopProxyWriter(visitor, this.isAopProxy || methodElement == null ? this.classElement.getAnnotationMetadata() : methodElement.getAnnotationMetadata(), this.visitorContext, false);
            this.beanDefinitionWriters.add(this.aopProxyVisitor);
            MethodElement constructorElement = this.classElement.getPrimaryConstructor().orElse(null);
            if (constructorElement != null) {
                this.aopProxyVisitor.visitBeanDefinitionConstructor(constructorElement, constructorElement.isPrivate(), this.visitorContext);
            } else {
                this.aopProxyVisitor.visitDefaultConstructor(AnnotationMetadata.EMPTY_METADATA, this.visitorContext);
            }
            this.aopProxyVisitor.visitSuperBeanDefinition(visitor.getBeanDefinitionName());
        }
        return this.aopProxyVisitor;
    }

    protected boolean processAsProperties() {
        return false;
    }

    private void build(BeanDefinitionVisitor visitor) {
        HashSet processedFields = new HashSet();
        ElementQuery<MemberElement> memberQuery = ElementQuery.ALL_FIELD_AND_METHODS.includeHiddenElements();
        if (this.processAsProperties()) {
            memberQuery = memberQuery.excludePropertyElements();
            for (PropertyElement propertyElement : this.classElement.getBeanProperties()) {
                propertyElement.getField().ifPresent(processedFields::add);
                this.visitPropertyInternal(visitor, propertyElement);
            }
        } else {
            for (PropertyElement propertyElement : this.classElement.getSyntheticBeanProperties()) {
                propertyElement.getField().ifPresent(processedFields::add);
                this.visitPropertyInternal(visitor, propertyElement);
            }
        }
        ArrayList<MemberElement> memberElements = new ArrayList<MemberElement>(this.classElement.getEnclosedElements(memberQuery));
        memberElements.removeIf(processedFields::contains);
        for (MemberElement memberElement : memberElements) {
            if (memberElement.hasAnnotation(Vetoed.class)) continue;
            if (memberElement instanceof FieldElement) {
                FieldElement fieldElement = (FieldElement)memberElement;
                this.visitFieldInternal(visitor, fieldElement);
                continue;
            }
            if (memberElement instanceof MethodElement) {
                MethodElement methodElement = (MethodElement)memberElement;
                this.visitMethodInternal(visitor, methodElement);
                continue;
            }
            if (memberElement instanceof PropertyElement) continue;
            throw new IllegalStateException("Unknown element");
        }
    }

    private void visitFieldInternal(BeanDefinitionVisitor visitor, FieldElement fieldElement) {
        boolean claimed = this.visitField(visitor, fieldElement);
        if (claimed) {
            this.addOriginatingElementIfNecessary(visitor, fieldElement);
        }
    }

    private void visitMethodInternal(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        this.makeInterceptedForValidationIfNeeded(methodElement);
        boolean claimed = this.visitMethod(visitor, methodElement);
        if (claimed) {
            this.addOriginatingElementIfNecessary(visitor, methodElement);
        }
    }

    private void visitPropertyInternal(BeanDefinitionVisitor visitor, PropertyElement propertyElement) {
        boolean claimed = this.visitProperty(visitor, propertyElement);
        if (claimed) {
            propertyElement.getReadMethod().ifPresent(element -> this.addOriginatingElementIfNecessary(visitor, (MemberElement)element));
            propertyElement.getWriteMethod().ifPresent(element -> this.addOriginatingElementIfNecessary(visitor, (MemberElement)element));
            propertyElement.getField().ifPresent(element -> this.addOriginatingElementIfNecessary(visitor, (MemberElement)element));
        }
    }

    protected boolean visitProperty(BeanDefinitionVisitor visitor, PropertyElement propertyElement) {
        Optional<? extends MemberElement> readMember;
        boolean claimed = false;
        Optional<? extends MemberElement> writeMember = propertyElement.getWriteMember();
        if (writeMember.isPresent()) {
            claimed |= this.visitPropertyWriteElement(visitor, propertyElement, writeMember.get());
        }
        if ((readMember = propertyElement.getReadMember()).isPresent()) {
            boolean readElementClaimed = this.visitPropertyReadElement(visitor, propertyElement, readMember.get());
            claimed |= readElementClaimed;
        }
        Optional<FieldElement> field = propertyElement.getField();
        if (!claimed && field.isPresent()) {
            FieldElement writeElement = field.get();
            claimed = this.visitField(visitor, writeElement);
        }
        return claimed;
    }

    protected void makeInterceptedForValidationIfNeeded(MethodElement element) {
        if (element.hasDeclaredAnnotation(ANN_REQUIRES_VALIDATION)) {
            element.annotate("io.micronaut.validation.Validated");
        }
    }

    protected boolean visitPropertyReadElement(BeanDefinitionVisitor visitor, PropertyElement propertyElement, MemberElement readElement) {
        if (readElement instanceof MethodElement) {
            MethodElement methodReadElement = (MethodElement)readElement;
            return this.visitPropertyReadElement(visitor, propertyElement, methodReadElement);
        }
        return false;
    }

    protected boolean visitPropertyReadElement(BeanDefinitionVisitor visitor, PropertyElement propertyElement, MethodElement readElement) {
        return this.visitAopAndExecutableMethod(visitor, readElement);
    }

    protected boolean visitPropertyWriteElement(BeanDefinitionVisitor visitor, PropertyElement propertyElement, MemberElement writeElement) {
        if (writeElement instanceof MethodElement) {
            MethodElement methodWriteElement = (MethodElement)writeElement;
            return this.visitPropertyWriteElement(visitor, propertyElement, methodWriteElement);
        }
        return false;
    }

    protected boolean visitPropertyWriteElement(BeanDefinitionVisitor visitor, PropertyElement propertyElement, MethodElement writeElement) {
        this.makeInterceptedForValidationIfNeeded(writeElement);
        if (this.visitInjectAndLifecycleMethod(visitor, writeElement)) {
            this.makeInterceptedForValidationIfNeeded(writeElement);
            return true;
        }
        if (!writeElement.isStatic() && writeElement.getMethodAnnotationMetadata().hasStereotype("jakarta.inject.Qualifier")) {
            if (propertyElement.getReadMethod().isPresent() && writeElement.hasStereotype(ANN_REQUIRES_VALIDATION)) {
                visitor.setValidated(true);
            }
            this.staticMethodCheck(writeElement);
            this.visitMethodInjectionPoint(visitor, writeElement);
            return true;
        }
        return this.visitAopAndExecutableMethod(visitor, writeElement);
    }

    protected boolean visitMethod(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        if (this.visitInjectAndLifecycleMethod(visitor, methodElement)) {
            return true;
        }
        return this.visitAopAndExecutableMethod(visitor, methodElement);
    }

    private boolean visitInjectAndLifecycleMethod(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        boolean claimed = false;
        if (methodElement.hasDeclaredAnnotation("jakarta.annotation.PostConstruct")) {
            this.staticMethodCheck(methodElement);
            visitor.visitPostConstructMethod(methodElement.getDeclaringType(), methodElement, methodElement.isReflectionRequired(this.classElement), this.visitorContext);
            claimed = true;
        }
        if (methodElement.hasDeclaredAnnotation("jakarta.annotation.PreDestroy")) {
            this.staticMethodCheck(methodElement);
            visitor.visitPreDestroyMethod(methodElement.getDeclaringType(), methodElement, methodElement.isReflectionRequired(this.classElement), this.visitorContext);
            claimed = true;
        }
        if (claimed) {
            return true;
        }
        if (!methodElement.isStatic() && this.isInjectPointMethod(methodElement)) {
            this.staticMethodCheck(methodElement);
            this.visitMethodInjectionPoint(visitor, methodElement);
            return true;
        }
        return false;
    }

    protected void visitMethodInjectionPoint(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        this.applyConfigurationInjectionIfNecessary(visitor, methodElement);
        visitor.visitMethodInjectionPoint(methodElement.getDeclaringType(), methodElement, methodElement.isReflectionRequired(this.classElement), this.visitorContext);
    }

    private boolean visitAopAndExecutableMethod(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        if (methodElement.isStatic() && DeclaredBeanElementCreator.isExplicitlyAnnotatedAsExecutable(methodElement)) {
            return false;
        }
        boolean preprocess = methodElement.isTrue(Executable.class, "processOnStartup");
        if (preprocess) {
            visitor.setRequiresMethodProcessing(true);
        }
        if (methodElement.hasStereotype(Adapter.class)) {
            this.staticMethodCheck(methodElement);
            this.visitAdaptedMethod(methodElement);
        }
        if (this.visitAopMethod(visitor, methodElement)) {
            return true;
        }
        return this.visitExecutableMethod(visitor, methodElement);
    }

    protected boolean visitAopMethod(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        boolean aopDefinedOnClassAndPublicMethod = this.isAopProxy && (methodElement.isPublic() || methodElement.isPackagePrivate());
        MutableAnnotationMetadataDelegate<AnnotationMetadata> methodAnnotationMetadata = methodElement.getMethodAnnotationMetadata();
        if (aopDefinedOnClassAndPublicMethod || !this.isAopProxy && InterceptedMethodUtil.hasAroundStereotype(methodAnnotationMetadata) || InterceptedMethodUtil.hasDeclaredAroundAdvice(methodAnnotationMetadata) && !this.classElement.isAbstract()) {
            if (methodElement.isFinal()) {
                if (InterceptedMethodUtil.hasDeclaredAroundAdvice(methodAnnotationMetadata)) {
                    throw new ProcessingException(methodElement, "Method defines AOP advice but is declared final. Change the method to be non-final in order for AOP advice to be applied.");
                }
                if (!methodElement.isSynthetic() && aopDefinedOnClassAndPublicMethod && this.isDeclaredInThisClass(methodElement)) {
                    throw new ProcessingException(methodElement, "Public method inherits AOP advice but is declared final. Either make the method non-public or apply AOP advice only to public methods declared on the class.");
                }
                return false;
            }
            if (methodElement.isPrivate()) {
                throw new ProcessingException(methodElement, "Method annotated as executable but is declared private. Change the method to be non-private in order for AOP advice to be applied.");
            }
            if (methodElement.isStatic()) {
                throw new ProcessingException(methodElement, "Method defines AOP advice but is declared static");
            }
            AopProxyWriter aopProxyVisitor = this.getAroundAopProxyVisitor(visitor, methodElement);
            this.visitAroundMethod(aopProxyVisitor, this.classElement, methodElement);
            return true;
        }
        return false;
    }

    protected void visitAroundMethod(AopProxyWriter aopProxyWriter, TypedElement beanType, MethodElement methodElement) {
        aopProxyWriter.visitInterceptorBinding(InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)methodElement.getAnnotationMetadata(), (InterceptorKind)InterceptorKind.AROUND));
        aopProxyWriter.visitAroundMethod(beanType, methodElement);
    }

    protected void applyConfigurationInjectionIfNecessary(BeanDefinitionVisitor visitor, MethodElement constructor) {
    }

    protected boolean isInjectPointMethod(MemberElement memberElement) {
        return memberElement.hasDeclaredStereotype("jakarta.inject.Inject");
    }

    private void staticMethodCheck(MethodElement methodElement) {
        if (methodElement.isStatic()) {
            if (!DeclaredBeanElementCreator.isExplicitlyAnnotatedAsExecutable(methodElement)) {
                throw new ProcessingException(methodElement, "Static methods only allowed when annotated with @Executable");
            }
            this.failIfMethodNotAccessible(methodElement);
        }
    }

    private void failIfMethodNotAccessible(MethodElement methodElement) {
        if (!methodElement.isAccessible(this.classElement)) {
            throw new ProcessingException(methodElement, "Method is not accessible for the invocation. To invoke the method using reflection annotate it with @ReflectiveAccess");
        }
    }

    private static boolean isExplicitlyAnnotatedAsExecutable(MethodElement methodElement) {
        return !methodElement.getMethodAnnotationMetadata().hasDeclaredAnnotation(Executable.class);
    }

    protected boolean visitField(BeanDefinitionVisitor visitor, FieldElement fieldElement) {
        if (fieldElement.isStatic() || fieldElement.isFinal()) {
            return false;
        }
        AnnotationMetadata fieldAnnotationMetadata = fieldElement.getAnnotationMetadata();
        if (fieldAnnotationMetadata.hasStereotype(Value.class) || fieldAnnotationMetadata.hasStereotype(Property.class)) {
            visitor.visitFieldValue(fieldElement.getDeclaringType(), fieldElement, fieldElement.isReflectionRequired(this.classElement), false);
            return true;
        }
        if (fieldAnnotationMetadata.hasStereotype("jakarta.inject.Inject") || fieldAnnotationMetadata.hasDeclaredStereotype("jakarta.inject.Qualifier")) {
            visitor.visitFieldInjectionPoint(fieldElement.getDeclaringType(), fieldElement, fieldElement.isReflectionRequired(this.classElement), this.visitorContext);
            return true;
        }
        return false;
    }

    private void addOriginatingElementIfNecessary(BeanDefinitionVisitor writer, MemberElement memberElement) {
        if (!memberElement.isSynthetic() && !this.isDeclaredInThisClass(memberElement)) {
            writer.addOriginatingElement(memberElement.getDeclaringType());
        }
    }

    protected boolean visitExecutableMethod(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        if (!methodElement.hasStereotype(Executable.class)) {
            return false;
        }
        if (methodElement.isSynthetic()) {
            return false;
        }
        if (methodElement.getMethodAnnotationMetadata().hasStereotype(Executable.class)) {
            if (!methodElement.isAccessible()) {
                throw new ProcessingException(methodElement, "Method annotated as executable but is declared private. To invoke the method using reflection annotate it with @ReflectiveAccess");
            }
        } else if (!(this.isDeclaredInThisClass(methodElement) || methodElement.getDeclaringType().hasStereotype(Executable.class) || methodElement.isPublic())) {
            return false;
        }
        if (methodElement.isAccessible() || !methodElement.isPrivate() && methodElement.getClass().getSimpleName().contains("Groovy")) {
            visitor.visitExecutableMethod(this.classElement, methodElement, this.visitorContext);
        }
        return true;
    }

    private boolean isDeclaredInThisClass(MemberElement memberElement) {
        return this.classElement.equals(memberElement.getDeclaringType());
    }

    private void visitAdaptedMethod(MethodElement sourceMethod) {
        AnnotationMetadata methodAnnotationMetadata = sourceMethod.getDeclaredMetadata();
        Optional interfaceToAdaptValue = methodAnnotationMetadata.getValue(Adapter.class, String.class).flatMap(clazz -> this.visitorContext.getClassElement((String)clazz, this.visitorContext.getElementAnnotationMetadataFactory().readOnly()));
        if (interfaceToAdaptValue.isEmpty()) {
            return;
        }
        ClassElement interfaceToAdapt = (ClassElement)interfaceToAdaptValue.get();
        if (!interfaceToAdapt.isInterface()) {
            throw new ProcessingException(sourceMethod, "Class to adapt [" + interfaceToAdapt.getName() + "] is not an interface");
        }
        String rootName = this.classElement.getSimpleName() + "$" + interfaceToAdapt.getSimpleName() + "$" + sourceMethod.getSimpleName();
        String beanClassName = rootName + this.adaptedMethodIndex.incrementAndGet();
        AopProxyWriter aopProxyWriter = new AopProxyWriter(this.classElement.getPackageName(), beanClassName, true, false, (Element)sourceMethod, (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.classElement.getAnnotationMetadata(), methodAnnotationMetadata}), new ClassElement[]{interfaceToAdapt}, this.visitorContext, new AnnotationValue[0]);
        aopProxyWriter.visitDefaultConstructor(methodAnnotationMetadata, this.visitorContext);
        List<MethodElement> methods = interfaceToAdapt.getEnclosedElements(ElementQuery.ALL_METHODS.onlyAbstract());
        if (methods.isEmpty()) {
            throw new ProcessingException(sourceMethod, "Interface to adapt [" + interfaceToAdapt.getName() + "] is not a SAM type. No methods found.");
        }
        if (methods.size() > 1) {
            throw new ProcessingException(sourceMethod, "Interface to adapt [" + interfaceToAdapt.getName() + "] is not a SAM type. More than one abstract method declared.");
        }
        MethodElement targetMethod = methods.iterator().next();
        ParameterElement[] sourceParams = sourceMethod.getParameters();
        ParameterElement[] targetParams = targetMethod.getParameters();
        int paramLen = targetParams.length;
        if (paramLen != sourceParams.length) {
            throw new ProcessingException(sourceMethod, MSG_ADAPTER_METHOD_PREFIX + sourceMethod + MSG_TARGET_METHOD_PREFIX + targetMethod + "]. Argument lengths don't match.");
        }
        if (sourceMethod.isSuspend()) {
            throw new ProcessingException(sourceMethod, MSG_ADAPTER_METHOD_PREFIX + sourceMethod + MSG_TARGET_METHOD_PREFIX + targetMethod + "]. Kotlin suspend method not supported here.");
        }
        Map<String, ClassElement> typeVariables = interfaceToAdapt.getTypeArguments();
        LinkedHashMap<String, ClassElement> genericTypes = new LinkedHashMap<String, ClassElement>(paramLen);
        for (int i = 0; i < paramLen; ++i) {
            GenericPlaceholderElement genericPlaceholderElement;
            String variableName;
            ParameterElement targetParam = targetParams[i];
            ParameterElement sourceParam = sourceParams[i];
            ClassElement targetType = targetParam.getType();
            ClassElement targetGenericType = targetParam.getGenericType();
            ClassElement sourceType = sourceParam.getGenericType();
            if (targetGenericType instanceof GenericPlaceholderElement) {
                GenericPlaceholderElement genericPlaceholderElement2 = (GenericPlaceholderElement)targetGenericType;
                variableName = genericPlaceholderElement2.getVariableName();
                if (typeVariables.containsKey(variableName)) {
                    genericTypes.put(variableName, sourceType);
                }
            } else if (targetType instanceof GenericPlaceholderElement && typeVariables.containsKey(variableName = (genericPlaceholderElement = (GenericPlaceholderElement)targetType).getVariableName())) {
                genericTypes.put(variableName, sourceType);
            }
            if (sourceType.isAssignable(targetGenericType.getName())) continue;
            throw new ProcessingException(sourceMethod, MSG_ADAPTER_METHOD_PREFIX + sourceMethod + MSG_TARGET_METHOD_PREFIX + targetMethod + "]. Type [" + sourceType.getName() + "] is not a subtype of type [" + targetGenericType.getName() + "] for argument at position " + i);
        }
        if (!genericTypes.isEmpty()) {
            aopProxyWriter.visitTypeArguments(Collections.singletonMap(interfaceToAdapt.getName(), genericTypes));
        }
        AnnotationClassValue[] adaptedArgumentTypes = (AnnotationClassValue[])Arrays.stream(sourceParams).map(p -> new AnnotationClassValue(JavaModelUtils.getClassname(p.getGenericType()))).toArray(AnnotationClassValue[]::new);
        targetMethod = targetMethod.withNewOwningType(this.classElement);
        targetMethod.annotate(Adapter.class, builder -> {
            builder.member("adaptedBean", new AnnotationClassValue[]{new AnnotationClassValue(JavaModelUtils.getClassname(this.classElement))});
            builder.member("adaptedMethod", sourceMethod.getName());
            builder.member("adaptedArgumentTypes", adaptedArgumentTypes);
            String qualifier = this.classElement.stringValue("jakarta.inject.Named").orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)qualifier)) {
                builder.member("adaptedQualifier", qualifier);
            }
        });
        aopProxyWriter.visitAroundMethod(interfaceToAdapt, targetMethod);
        this.beanDefinitionWriters.add(aopProxyWriter);
    }
}

