/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.context.AbstractInitializableBeanDefinitionReference;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public class BeanDefinitionReferenceWriter
extends AbstractAnnotationMetadataWriter {
    public static final String REF_SUFFIX = "$Reference";
    private static final Method BEAN_DEFINITION_REF_CLASS_CONSTRUCTOR = new Method("<init>", BeanDefinitionReferenceWriter.getConstructorDescriptor(String.class, String.class, AnnotationMetadata.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE));
    private final String beanTypeName;
    private final String beanDefinitionName;
    private final String beanDefinitionClassInternalName;
    private final String beanDefinitionReferenceClassName;
    private final Type interceptedType;
    private final Type providedType;
    private final Map<String, ClassElement> typeParameters;
    private final boolean proxiedBean;
    private final boolean proxyTarget;
    private boolean contextScope = false;
    private boolean requiresMethodProcessing;

    public BeanDefinitionReferenceWriter(BeanDefinitionVisitor visitor, VisitorContext visitorContext) {
        super(visitor.getBeanDefinitionName() + REF_SUFFIX, visitor, visitor.getAnnotationMetadata(), true, visitorContext);
        this.providedType = visitor.getProvidedType();
        this.beanTypeName = visitor.getBeanTypeName();
        this.typeParameters = visitor.getTypeArgumentMap();
        this.beanDefinitionName = visitor.getBeanDefinitionName();
        this.beanDefinitionReferenceClassName = this.beanDefinitionName + REF_SUFFIX;
        this.beanDefinitionClassInternalName = BeanDefinitionReferenceWriter.getInternalName(this.beanDefinitionName) + REF_SUFFIX;
        this.interceptedType = visitor.getInterceptedType().orElse(null);
        this.proxiedBean = visitor.isProxiedBean();
        this.proxyTarget = visitor.isProxyTarget();
    }

    @Override
    public void accept(ClassWriterOutputVisitor outputVisitor) throws IOException {
        try (OutputStream outputStream = outputVisitor.visitClass(this.getBeanDefinitionQualifiedClassName(), this.getOriginatingElements());){
            ClassWriter classWriter = this.generateClassBytes();
            outputStream.write(classWriter.toByteArray());
        }
        outputVisitor.visitServiceDescriptor(BeanDefinitionReference.class, this.beanDefinitionReferenceClassName, this.getOriginatingElement());
    }

    public void setContextScope(boolean contextScope) {
        this.contextScope = contextScope;
    }

    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.requiresMethodProcessing = shouldPreProcess;
    }

    public String getBeanDefinitionQualifiedClassName() {
        String newClassName = this.beanDefinitionName;
        if (newClassName.endsWith("[]")) {
            newClassName = newClassName.substring(0, newClassName.length() - 2);
        }
        return newClassName + REF_SUFFIX;
    }

    private ClassWriter generateClassBytes() {
        ClassWriter classWriter = new ClassWriter(1);
        Type superType = Type.getType(AbstractInitializableBeanDefinitionReference.class);
        String[] interfaceInternalNames = this.interceptedType != null ? new String[]{Type.getType(AdvisedBeanType.class).getInternalName()} : StringUtils.EMPTY_STRING_ARRAY;
        this.startService((ClassVisitor)classWriter, BeanDefinitionReference.class.getName(), this.beanDefinitionClassInternalName, superType, interfaceInternalNames);
        Type beanDefinitionType = BeanDefinitionReferenceWriter.getTypeReferenceForName(this.beanDefinitionName, new String[0]);
        GeneratorAdapter cv = this.startConstructor((ClassVisitor)classWriter);
        cv.loadThis();
        cv.push(this.beanTypeName);
        cv.push(this.beanDefinitionName);
        if (this.annotationMetadata == AnnotationMetadata.EMPTY_METADATA || this.annotationMetadata.isEmpty()) {
            cv.getStatic(Type.getType(AnnotationMetadata.class), "EMPTY_METADATA", Type.getType(AnnotationMetadata.class));
        } else if (this.annotationMetadata instanceof AnnotationMetadataReference) {
            AnnotationMetadataReference reference = (AnnotationMetadataReference)this.annotationMetadata;
            String className = reference.getClassName();
            cv.getStatic(BeanDefinitionReferenceWriter.getTypeReferenceForName(className, new String[0]), "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
        } else {
            cv.getStatic(this.targetClassType, "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
        }
        cv.push(this.annotationMetadata.hasDeclaredStereotype(Primary.class));
        cv.push(this.contextScope);
        cv.push(this.annotationMetadata.hasStereotype(Requires.class));
        cv.push(this.providedType.getSort() == 9 || DefaultArgument.CONTAINER_TYPES.stream().anyMatch(clazz -> clazz.equals(this.beanTypeName)));
        cv.push(this.annotationMetadata.hasDeclaredStereotype("jakarta.inject.Singleton") || !this.annotationMetadata.hasDeclaredStereotype("jakarta.inject.Scope") && this.annotationMetadata.hasDeclaredStereotype(DefaultScope.class) && this.annotationMetadata.stringValue(DefaultScope.class).map(t -> t.equals(Singleton.class.getName()) || t.equals("jakarta.inject.Singleton")).orElse(false) != false);
        cv.push(this.annotationMetadata.hasDeclaredStereotype(ConfigurationReader.class));
        cv.push(this.annotationMetadata.hasDeclaredAnnotation(Bean.class) && this.annotationMetadata.stringValues(Bean.class, "typed").length > 0);
        cv.push(this.requiresMethodProcessing);
        cv.push(this.proxiedBean);
        cv.push(this.proxyTarget);
        cv.invokeConstructor(Type.getType(AbstractInitializableBeanDefinitionReference.class), BEAN_DEFINITION_REF_CLASS_CONSTRUCTOR);
        cv.visitInsn(177);
        cv.visitMaxs(2, 1);
        GeneratorAdapter loadMethod = this.startPublicMethodZeroArgs(classWriter, BeanDefinition.class, "load");
        this.pushNewInstance(loadMethod, beanDefinitionType);
        loadMethod.returnValue();
        loadMethod.visitMaxs(2, 1);
        GeneratorAdapter getBeanDefinitionType = this.startPublicMethodZeroArgs(classWriter, Class.class, "getBeanDefinitionType");
        getBeanDefinitionType.push(beanDefinitionType);
        getBeanDefinitionType.returnValue();
        getBeanDefinitionType.visitMaxs(2, 1);
        GeneratorAdapter getBeanType = this.startPublicMethodZeroArgs(classWriter, Class.class, "getBeanType");
        getBeanType.push(this.providedType);
        getBeanType.returnValue();
        getBeanType.visitMaxs(2, 1);
        if (CollectionUtils.isNotEmpty(this.typeParameters)) {
            GeneratorAdapter getGenericType = this.startPublicMethodZeroArgs(classWriter, Argument.class, "getGenericBeanType");
            BeanDefinitionReferenceWriter.pushCreateArgument(this.annotationMetadata, this.beanDefinitionReferenceClassName, Type.getType((String)BeanDefinitionReferenceWriter.getTypeDescriptor(this.beanDefinitionReferenceClassName)), classWriter, getGenericType, "T", ClassElement.of(this.beanTypeName), this.annotationMetadata, this.typeParameters, new HashMap<String, Integer>(), this.loadTypeMethods);
            getGenericType.returnValue();
            getGenericType.visitMaxs(2, 1);
        }
        this.writeAnnotationMetadataStaticInitializer(classWriter);
        if (this.interceptedType != null) {
            super.implementInterceptedTypeMethod(this.interceptedType, classWriter);
        }
        for (GeneratorAdapter generatorAdapter : this.loadTypeMethods.values()) {
            generatorAdapter.visitMaxs(3, 1);
            generatorAdapter.visitEnd();
        }
        return classWriter;
    }
}

