/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import io.micronaut.expressions.EvaluatedExpressionWriter;
import io.micronaut.expressions.context.DefaultExpressionCompilationContextFactory;
import io.micronaut.expressions.context.ExpressionCompilationContext;
import io.micronaut.expressions.context.ExpressionWithContext;
import io.micronaut.expressions.util.EvaluatedExpressionsUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

@Internal
public final class EvaluatedExpressionProcessor {
    private final Collection<ExpressionWithContext> evaluatedExpressions = new ArrayList<ExpressionWithContext>(2);
    private final DefaultExpressionCompilationContextFactory expressionCompilationContextFactory;
    private final VisitorContext visitorContext;
    private final Element originatingElement;

    public EvaluatedExpressionProcessor(VisitorContext visitorContext, Element originatingElement) {
        this.visitorContext = visitorContext;
        this.expressionCompilationContextFactory = new DefaultExpressionCompilationContextFactory(visitorContext);
        this.originatingElement = originatingElement;
    }

    public static void reset() {
        DefaultExpressionCompilationContextFactory.reset();
    }

    public void processEvaluatedExpressions(AnnotationMetadata annotationMetadata, @Nullable ClassElement thisElement) {
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            annotationMetadata = annotationMetadata.getDeclaredMetadata();
        }
        Collection<EvaluatedExpressionReference> expressionReferences = EvaluatedExpressionsUtils.findEvaluatedExpressionReferences(annotationMetadata);
        expressionReferences.stream().map(expressionReference -> {
            ExpressionCompilationContext evaluationContext = this.expressionCompilationContextFactory.buildContext((EvaluatedExpressionReference)expressionReference, thisElement);
            return new ExpressionWithContext((EvaluatedExpressionReference)expressionReference, evaluationContext);
        }).forEach(this.evaluatedExpressions::add);
    }

    public void processEvaluatedExpressions(MethodElement methodElement) {
        Collection<EvaluatedExpressionReference> expressionReferences = EvaluatedExpressionsUtils.findEvaluatedExpressionReferences(methodElement.getDeclaredMetadata());
        expressionReferences.stream().map(expression -> {
            ExpressionCompilationContext evaluationContext = this.expressionCompilationContextFactory.buildContextForMethod((EvaluatedExpressionReference)expression, methodElement);
            return new ExpressionWithContext((EvaluatedExpressionReference)expression, evaluationContext);
        }).forEach(this.evaluatedExpressions::add);
    }

    public Collection<ExpressionWithContext> getEvaluatedExpressions() {
        return this.evaluatedExpressions;
    }

    public void writeEvaluatedExpressions(ClassWriterOutputVisitor visitor) throws IOException {
        for (ExpressionWithContext expressionMetadata : this.getEvaluatedExpressions()) {
            EvaluatedExpressionWriter expressionWriter = new EvaluatedExpressionWriter(expressionMetadata, this.visitorContext, this.originatingElement);
            expressionWriter.accept(visitor);
        }
    }

    public boolean hasEvaluatedExpressions() {
        return !this.evaluatedExpressions.isEmpty();
    }
}

