/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.context.AbstractExecutableMethodsDefinition;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.DispatchWriter;
import io.micronaut.inject.writer.EvaluatedExpressionProcessor;
import io.micronaut.inject.writer.OriginatingElements;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.TableSwitchGenerator;

@Internal
public class ExecutableMethodsDefinitionWriter
extends AbstractClassFileWriter
implements Opcodes {
    public static final String CLASS_SUFFIX = "$Exec";
    public static final Method GET_EXECUTABLE_AT_INDEX_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractExecutableMethodsDefinition.class, (String)"getExecutableMethodByIndex", (Class[])new Class[]{Integer.TYPE}));
    public static final Type SUPER_TYPE = Type.getType(AbstractExecutableMethodsDefinition.class);
    private static final Method SUPER_CONSTRUCTOR = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AbstractExecutableMethodsDefinition.class, (Class[])new Class[]{AbstractExecutableMethodsDefinition.MethodReference[].class}));
    private static final Method WITH_INTERCEPTED_CONSTRUCTOR = new Method("<init>", ExecutableMethodsDefinitionWriter.getConstructorDescriptor(Boolean.TYPE));
    private static final Method GET_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractExecutableMethodsDefinition.class, (String)"getMethod", (Class[])new Class[]{String.class, Class[].class}));
    private static final Method AT_INDEX_MATCHED_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractExecutableMethodsDefinition.class, (String)"methodAtIndexMatches", (Class[])new Class[]{Integer.TYPE, String.class, Class[].class}));
    private static final String FIELD_METHODS_REFERENCES = "$METHODS_REFERENCES";
    private static final String FIELD_INTERCEPTABLE = "$interceptable";
    private static final int MIN_METHODS_TO_GENERATE_GET_METHOD = 5;
    private final String className;
    private final String internalName;
    private final Type thisType;
    private final String beanDefinitionReferenceClassName;
    private final Map<String, GeneratorAdapter> loadTypeMethods = new LinkedHashMap<String, GeneratorAdapter>();
    private final List<String> addedMethods = new ArrayList<String>();
    private final DispatchWriter methodDispatchWriter;
    private final Set<String> methodNames = new HashSet<String>();
    private final AnnotationMetadata annotationMetadataWithDefaults;
    private final EvaluatedExpressionProcessor evaluatedExpressionProcessor;
    private ClassWriter classWriter;

    public ExecutableMethodsDefinitionWriter(VisitorContext visitorContext, EvaluatedExpressionProcessor evaluatedExpressionProcessor, AnnotationMetadata annotationMetadataWithDefaults, String beanDefinitionClassName, String beanDefinitionReferenceClassName, OriginatingElements originatingElements) {
        super(originatingElements);
        this.annotationMetadataWithDefaults = annotationMetadataWithDefaults;
        this.evaluatedExpressionProcessor = evaluatedExpressionProcessor;
        this.className = beanDefinitionClassName + CLASS_SUFFIX;
        this.internalName = ExecutableMethodsDefinitionWriter.getInternalName(this.className);
        this.thisType = Type.getObjectType((String)this.internalName);
        this.beanDefinitionReferenceClassName = beanDefinitionReferenceClassName;
        this.methodDispatchWriter = new DispatchWriter(this.thisType);
    }

    public String getClassName() {
        return this.className;
    }

    public Type getClassType() {
        return this.thisType;
    }

    private MethodElement getMethodElement(int index) {
        return ((DispatchWriter.MethodDispatchTarget)this.methodDispatchWriter.getDispatchTargets().get((int)index)).methodElement;
    }

    public boolean isSupportsInterceptedProxy() {
        return this.methodDispatchWriter.isHasInterceptedMethod();
    }

    public boolean isAbstract(int index) {
        MethodElement methodElement = this.getMethodElement(index);
        return this.isInterface(index) && !methodElement.isDefault() || methodElement.isAbstract();
    }

    public boolean isInterface(int index) {
        return this.getMethodElement(index).getDeclaringType().isInterface();
    }

    public boolean isDefault(int index) {
        return this.getMethodElement(index).isDefault();
    }

    public boolean isSuspend(int index) {
        return this.getMethodElement(index).isSuspend();
    }

    public int visitExecutableMethod(TypedElement declaringType, MethodElement methodElement, String interceptedProxyClassName, String interceptedProxyBridgeMethodName) {
        this.evaluatedExpressionProcessor.processEvaluatedExpressions(methodElement);
        String methodKey = methodElement.getName() + "(" + Arrays.stream(methodElement.getSuspendParameters()).map(p -> p.getType().getName()).collect(Collectors.joining(",")) + ")";
        int index = this.addedMethods.indexOf(methodKey);
        if (index > -1) {
            return index;
        }
        this.addedMethods.add(methodKey);
        if (interceptedProxyClassName == null) {
            return this.methodDispatchWriter.addMethod(declaringType, methodElement);
        }
        return this.methodDispatchWriter.addInterceptedMethod(declaringType, methodElement, interceptedProxyClassName, interceptedProxyBridgeMethodName);
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        try (OutputStream outputStream = classWriterOutputVisitor.visitClass(this.className, this.getOriginatingElements());){
            outputStream.write(this.classWriter.toByteArray());
        }
    }

    public final void visitDefinitionEnd() {
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(61, 4112, this.internalName, null, SUPER_TYPE.getInternalName(), null);
        this.classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
        Type methodsFieldType = Type.getType(AbstractExecutableMethodsDefinition.MethodReference[].class);
        this.buildStaticInit(this.classWriter, methodsFieldType);
        this.buildConstructor(this.classWriter, methodsFieldType);
        this.methodDispatchWriter.buildDispatchMethod(this.classWriter);
        this.methodDispatchWriter.buildGetTargetMethodByIndex(this.classWriter);
        if (this.methodDispatchWriter.getDispatchTargets().size() > 5) {
            this.buildGetMethod(this.classWriter);
        }
        for (GeneratorAdapter method : this.loadTypeMethods.values()) {
            method.visitMaxs(3, 1);
            method.visitEnd();
        }
        this.classWriter.visitEnd();
    }

    private void buildStaticInit(ClassWriter classWriter, Type methodsFieldType) {
        GeneratorAdapter staticInit = this.visitStaticInitializer((ClassVisitor)classWriter);
        classWriter.visitField(26, FIELD_METHODS_REFERENCES, methodsFieldType.getDescriptor(), null, null);
        ExecutableMethodsDefinitionWriter.pushNewArray(staticInit, AbstractExecutableMethodsDefinition.MethodReference.class, this.methodDispatchWriter.getDispatchTargets().size());
        int i = 0;
        for (DispatchWriter.DispatchTarget dispatchTarget : this.methodDispatchWriter.getDispatchTargets()) {
            DispatchWriter.MethodDispatchTarget method = (DispatchWriter.MethodDispatchTarget)dispatchTarget;
            ExecutableMethodsDefinitionWriter.pushStoreInArray(staticInit, i++, this.methodDispatchWriter.getDispatchTargets().size(), () -> this.pushNewMethodReference(classWriter, staticInit, method.declaringType, method.methodElement));
        }
        staticInit.putStatic(this.thisType, FIELD_METHODS_REFERENCES, methodsFieldType);
        staticInit.returnValue();
        staticInit.visitMaxs(13, 1);
        staticInit.visitEnd();
    }

    private void buildConstructor(ClassWriter classWriter, Type methodsFieldType) {
        boolean includeInterceptedField = this.methodDispatchWriter.isHasInterceptedMethod();
        if (includeInterceptedField) {
            classWriter.visitField(18, FIELD_INTERCEPTABLE, Type.getType(Boolean.TYPE).getDescriptor(), null, null);
            GeneratorAdapter defaultConstructorWriter = this.startConstructor((ClassVisitor)classWriter);
            defaultConstructorWriter.loadThis();
            defaultConstructorWriter.push(false);
            defaultConstructorWriter.invokeConstructor(this.thisType, WITH_INTERCEPTED_CONSTRUCTOR);
            defaultConstructorWriter.returnValue();
            defaultConstructorWriter.visitMaxs(1, 1);
            defaultConstructorWriter.visitEnd();
            GeneratorAdapter withInterceptedConstructor = this.startConstructor((ClassVisitor)classWriter, Boolean.TYPE);
            withInterceptedConstructor.loadThis();
            withInterceptedConstructor.getStatic(this.thisType, FIELD_METHODS_REFERENCES, methodsFieldType);
            withInterceptedConstructor.invokeConstructor(SUPER_TYPE, SUPER_CONSTRUCTOR);
            withInterceptedConstructor.loadThis();
            withInterceptedConstructor.loadArg(0);
            withInterceptedConstructor.putField(this.thisType, FIELD_INTERCEPTABLE, Type.getType(Boolean.TYPE));
            withInterceptedConstructor.returnValue();
            withInterceptedConstructor.visitMaxs(1, 1);
            withInterceptedConstructor.visitEnd();
        } else {
            GeneratorAdapter constructorWriter = this.startConstructor((ClassVisitor)classWriter);
            constructorWriter.loadThis();
            constructorWriter.getStatic(this.thisType, FIELD_METHODS_REFERENCES, methodsFieldType);
            constructorWriter.invokeConstructor(SUPER_TYPE, SUPER_CONSTRUCTOR);
            constructorWriter.returnValue();
            constructorWriter.visitMaxs(1, 1);
            constructorWriter.visitEnd();
        }
    }

    private void buildGetMethod(ClassWriter classWriter) {
        final GeneratorAdapter findMethod = new GeneratorAdapter(classWriter.visitMethod(18, GET_METHOD.getName(), GET_METHOD.getDescriptor(), null, null), 18, GET_METHOD.getName(), GET_METHOD.getDescriptor());
        findMethod.loadThis();
        findMethod.loadArg(0);
        findMethod.invokeVirtual(Type.getType(Object.class), new Method("hashCode", Type.INT_TYPE, new Type[0]));
        final TreeMap<Integer, List> hashToMethods = new TreeMap<Integer, List>();
        for (DispatchWriter.DispatchTarget dispatchTarget : this.methodDispatchWriter.getDispatchTargets()) {
            DispatchWriter.MethodDispatchTarget method = (DispatchWriter.MethodDispatchTarget)dispatchTarget;
            int hash = method.methodElement.getName().hashCode();
            hashToMethods.computeIfAbsent(hash, h -> new ArrayList()).add(method);
        }
        int[] hashCodeArray = hashToMethods.keySet().stream().mapToInt(i -> i).toArray();
        findMethod.tableSwitch(hashCodeArray, new TableSwitchGenerator(){

            public void generateCase(int hashCode, Label end) {
                for (DispatchWriter.MethodDispatchTarget method : (List)hashToMethods.get(hashCode)) {
                    int index = ExecutableMethodsDefinitionWriter.this.methodDispatchWriter.getDispatchTargets().indexOf(method);
                    if (index < 0) {
                        throw new IllegalStateException();
                    }
                    findMethod.loadThis();
                    findMethod.push(index);
                    findMethod.loadArg(0);
                    findMethod.loadArg(1);
                    findMethod.invokeVirtual(SUPER_TYPE, AT_INDEX_MATCHED_METHOD);
                    findMethod.push(true);
                    Label falseLabel = new Label();
                    findMethod.ifCmp(Type.BOOLEAN_TYPE, 154, falseLabel);
                    findMethod.loadThis();
                    findMethod.push(index);
                    findMethod.invokeVirtual(SUPER_TYPE, GET_EXECUTABLE_AT_INDEX_METHOD);
                    findMethod.returnValue();
                    findMethod.visitLabel(falseLabel);
                }
                findMethod.goTo(end);
            }

            public void generateDefault() {
            }
        });
        findMethod.push((String)null);
        findMethod.returnValue();
        findMethod.visitMaxs(13, 1);
        findMethod.visitEnd();
    }

    private void pushNewMethodReference(ClassWriter classWriter, GeneratorAdapter staticInit, TypedElement declaringType, MethodElement methodElement) {
        int index = 1;
        String prefix = "$metadata$";
        String methodName = prefix + methodElement.getName();
        while (this.methodNames.contains(methodName)) {
            methodName = prefix + methodElement.getName() + "$" + index++;
        }
        this.methodNames.add(methodName);
        Method newMethod = new Method(methodName, Type.getType(AbstractExecutableMethodsDefinition.MethodReference.class), new Type[0]);
        GeneratorAdapter newMethodAdapter = new GeneratorAdapter(classWriter.visitMethod(26, newMethod.getName(), newMethod.getDescriptor(), null, null), 26, newMethod.getName(), newMethod.getDescriptor());
        this.pushNewMethodReference0(classWriter, newMethodAdapter, declaringType, methodElement, new LinkedHashMap<String, Integer>());
        newMethodAdapter.returnValue();
        newMethodAdapter.visitMaxs(13, 1);
        newMethodAdapter.visitEnd();
        staticInit.invokeStatic(this.thisType, newMethod);
    }

    private void pushNewMethodReference0(ClassWriter classWriter, GeneratorAdapter staticInit, TypedElement declaringType, MethodElement methodElement, Map<String, Integer> defaultsStorage) {
        staticInit.newInstance(Type.getType(AbstractExecutableMethodsDefinition.MethodReference.class));
        staticInit.dup();
        Type typeReference = JavaModelUtils.getTypeReference(declaringType.getType());
        staticInit.push(typeReference);
        AnnotationMetadata annotationMetadata = methodElement.getTargetAnnotationMetadata();
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy hierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
            if (hierarchy.size() != 2) {
                throw new IllegalStateException("Expected the size of 2");
            }
            if (hierarchy.getRootMetadata().equals(methodElement.getOwningType())) {
                annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{new AnnotationMetadataReference(this.beanDefinitionReferenceClassName, (AnnotationMetadata)methodElement.getOwningType()), annotationMetadata.getDeclaredMetadata()});
            }
        }
        this.pushAnnotationMetadata(this.annotationMetadataWithDefaults, classWriter, staticInit, annotationMetadata, defaultsStorage);
        staticInit.push(methodElement.getName());
        ClassElement genericReturnType = methodElement.getGenericReturnType();
        this.pushReturnTypeArgument(this.annotationMetadataWithDefaults, this.thisType, classWriter, staticInit, declaringType.getName(), genericReturnType, defaultsStorage, this.loadTypeMethods);
        ParameterElement[] parameters = methodElement.getSuspendParameters();
        if (parameters.length == 0) {
            staticInit.visitInsn(1);
        } else {
            ExecutableMethodsDefinitionWriter.pushBuildArgumentsForMethod(this.annotationMetadataWithDefaults, typeReference.getClassName(), this.thisType, classWriter, staticInit, Arrays.asList(parameters), defaultsStorage, this.loadTypeMethods);
        }
        staticInit.push(methodElement.isAbstract());
        staticInit.push(methodElement.isSuspend());
        this.invokeConstructor((MethodVisitor)staticInit, AbstractExecutableMethodsDefinition.MethodReference.class, Class.class, AnnotationMetadata.class, String.class, Argument.class, Argument[].class, Boolean.TYPE, Boolean.TYPE);
    }

    private void pushAnnotationMetadata(AnnotationMetadata annotationMetadataWithDefaults, ClassWriter classWriter, GeneratorAdapter staticInit, AnnotationMetadata annotationMetadata, Map<String, Integer> defaultsStorage) {
        if (annotationMetadata == AnnotationMetadata.EMPTY_METADATA || annotationMetadata.isEmpty()) {
            staticInit.push((String)null);
        } else if (annotationMetadata instanceof AnnotationMetadataReference) {
            AnnotationMetadataReference annotationMetadataReference = (AnnotationMetadataReference)annotationMetadata;
            String className = annotationMetadataReference.getClassName();
            staticInit.getStatic(ExecutableMethodsDefinitionWriter.getTypeReferenceForName(className, new String[0]), "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
        } else if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
            MutableAnnotationMetadata.contributeDefaults((AnnotationMetadata)annotationMetadataWithDefaults, (AnnotationMetadataHierarchy)annotationMetadataHierarchy);
            AnnotationMetadataWriter.instantiateNewMetadataHierarchy(this.thisType, classWriter, staticInit, annotationMetadataHierarchy, defaultsStorage, this.loadTypeMethods);
        } else if (annotationMetadata instanceof MutableAnnotationMetadata) {
            MutableAnnotationMetadata mutableAnnotationMetadata = (MutableAnnotationMetadata)annotationMetadata;
            MutableAnnotationMetadata.contributeDefaults((AnnotationMetadata)annotationMetadataWithDefaults, (AnnotationMetadata)annotationMetadata);
            AnnotationMetadataWriter.instantiateNewMetadata(this.thisType, classWriter, staticInit, mutableAnnotationMetadata, defaultsStorage, this.loadTypeMethods);
        } else {
            throw new IllegalStateException("Unknown metadata: " + annotationMetadata);
        }
    }
}

