/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client.aop;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionDiscoveryClient;
import io.micronaut.function.client.FunctionInvoker;
import io.micronaut.function.client.FunctionInvokerChooser;
import io.micronaut.function.client.exceptions.FunctionNotFoundException;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
public class FunctionClientAdvice
implements MethodInterceptor<Object, Object> {
    private final FunctionDiscoveryClient discoveryClient;
    private final FunctionInvokerChooser functionInvokerChooser;

    public FunctionClientAdvice(FunctionDiscoveryClient discoveryClient, FunctionInvokerChooser functionInvokerChooser) {
        this.discoveryClient = discoveryClient;
        this.functionInvokerChooser = functionInvokerChooser;
    }

    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Map parameterValueMap = context.getParameterValueMap();
        int len = parameterValueMap.size();
        Map body = len == 1 ? parameterValueMap.values().iterator().next() : (len == 0 ? null : parameterValueMap);
        String functionName = context.stringValue("javax.inject.Named").orElse(NameUtils.hyphenate((String)context.getMethodName(), (boolean)true));
        Flux functionDefinition = Flux.from(this.discoveryClient.getFunction(functionName));
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
        try {
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(this.invokeFn(body, functionName, (Flux<FunctionDefinition>)functionDefinition, interceptedMethod.returnTypeValue()));
                }
                case COMPLETION_STAGE: {
                    return interceptedMethod.handleResult(this.toCompletableFuture(this.invokeFn(body, functionName, (Flux<FunctionDefinition>)functionDefinition, interceptedMethod.returnTypeValue())));
                }
                case SYNCHRONOUS: {
                    FunctionDefinition def = (FunctionDefinition)functionDefinition.blockFirst();
                    FunctionInvoker functionInvoker = this.functionInvokerChooser.choose(def).orElseThrow(() -> new FunctionNotFoundException(def.getName()));
                    return functionInvoker.invoke(def, body, context.getReturnType().asArgument());
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    private Flux<Object> invokeFn(Object body, String functionName, Flux<FunctionDefinition> functionDefinition, Argument<?> valueType) {
        return functionDefinition.next().flatMap(def -> {
            FunctionInvoker functionInvoker = this.functionInvokerChooser.choose((FunctionDefinition)def).orElseThrow(() -> new FunctionNotFoundException(def.getName()));
            return Mono.from((Publisher)((Publisher)functionInvoker.invoke((FunctionDefinition)def, body, Argument.of(Publisher.class, (Argument[])new Argument[]{valueType}))));
        }).switchIfEmpty(Mono.error(() -> new FunctionNotFoundException(functionName))).flux();
    }

    private CompletableFuture<Object> toCompletableFuture(Flux<Object> flowable) {
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        flowable.next().subscribe(completableFuture::complete, completableFuture::completeExceptionally, () -> completableFuture.complete(null));
        return completableFuture;
    }
}

