/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionDefinitionProvider;
import io.micronaut.function.client.FunctionDiscoveryClient;
import io.micronaut.function.client.exceptions.FunctionNotFoundException;
import io.micronaut.health.HealthStatus;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
public class DefaultFunctionDiscoveryClient
implements FunctionDiscoveryClient {
    private final DiscoveryClient discoveryClient;
    private final Map<String, FunctionDefinition> functionDefinitionMap;

    public DefaultFunctionDiscoveryClient(DiscoveryClient discoveryClient, FunctionDefinitionProvider[] providers, FunctionDefinition ... definitions) {
        this.discoveryClient = discoveryClient;
        this.functionDefinitionMap = CollectionUtils.newHashMap((int)definitions.length);
        for (FunctionDefinition definition : definitions) {
            this.functionDefinitionMap.put(definition.getName(), definition);
        }
        for (FunctionDefinitionProvider provider : providers) {
            Collection<FunctionDefinition> functionDefinitions = provider.getFunctionDefinitions();
            for (FunctionDefinition definition : functionDefinitions) {
                this.functionDefinitionMap.put(definition.getName(), definition);
            }
        }
    }

    @Override
    public Publisher<FunctionDefinition> getFunction(final String functionName) {
        if (this.functionDefinitionMap.containsKey(functionName)) {
            return Publishers.just((Object)this.functionDefinitionMap.get(functionName));
        }
        Flux serviceInstanceLocator = Flux.from((Publisher)this.discoveryClient.getServiceIds()).flatMap(Flux::fromIterable).flatMap(arg_0 -> ((DiscoveryClient)this.discoveryClient).getInstances(arg_0)).flatMap(Flux::fromIterable).filter(instance -> {
            boolean isAvailable = instance.getHealthStatus().equals((Object)HealthStatus.UP);
            return isAvailable && instance.getMetadata().names().stream().anyMatch(k -> k.equals("function:" + functionName));
        }).switchIfEmpty((Publisher)Flux.error((Throwable)new FunctionNotFoundException(functionName)));
        return serviceInstanceLocator.map(instance -> {
            Optional uri = instance.getMetadata().get((CharSequence)("function:" + functionName), String.class);
            if (uri.isPresent()) {
                final URI resolvedURI = instance.getURI().resolve((String)uri.get());
                return new FunctionDefinition(){

                    @Override
                    public String getName() {
                        return functionName;
                    }

                    @Override
                    public Optional<URI> getURI() {
                        return Optional.of(resolvedURI);
                    }
                };
            }
            throw new FunctionNotFoundException(functionName);
        });
    }
}

