/*
 * Copyright 2017-2019 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.micronaut.http.client.interceptor.configuration;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;

import static io.micronaut.http.client.interceptor.configuration.ClientVersioningConfiguration.DEFAULT;

/**
 * Client versioning configuration for named configurations nested under {@code micronaut.http.client.versioning}.
 */
@EachProperty(value = ClientVersioningConfiguration.PREFIX, primary = DEFAULT)
public class NamedClientVersioningConfiguration extends ClientVersioningConfiguration {

    /**
     * Creates a new configuration for the given client ID.
     *
     * @param clientName ID of the {@link io.micronaut.http.client.annotation.Client} to apply configuration for.
     */
    NamedClientVersioningConfiguration(@Parameter String clientName) {
        super(clientName);
    }
}
