/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.content;

import io.micronaut.core.annotation.Internal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import java.nio.charset.StandardCharsets;

@Internal
public class HttpContentUtil {
    public static final byte[] OPEN_BRACKET = "[".getBytes(StandardCharsets.UTF_8);
    public static final byte[] CLOSE_BRACKET = "]".getBytes(StandardCharsets.UTF_8);
    public static final byte[] COMMA = ",".getBytes(StandardCharsets.UTF_8);

    public static HttpContent openBracket() {
        return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])OPEN_BRACKET));
    }

    public static HttpContent closeBracket() {
        return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])CLOSE_BRACKET));
    }

    public static HttpContent prefixComma(HttpContent httpContent) {
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)2);
        compositeByteBuf.addComponent(true, Unpooled.wrappedBuffer((byte[])COMMA));
        compositeByteBuf.addComponent(true, httpContent.content());
        return httpContent.replace((ByteBuf)compositeByteBuf);
    }
}

