/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.netty.NettyHttpParameters;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.stream.DefaultStreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.DefaultAttributeMap;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Internal
public abstract class AbstractNettyHttpRequest<B>
extends DefaultAttributeMap
implements HttpRequest<B>,
NettyHttpRequestBuilder {
    public static final AsciiString STREAM_ID = HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text();
    public static final AsciiString HTTP2_SCHEME = HttpConversionUtil.ExtensionHeaderNames.SCHEME.text();
    protected final io.netty.handler.codec.http.HttpRequest nettyRequest;
    protected final ConversionService<?> conversionService;
    protected final HttpMethod httpMethod;
    protected final URI uri;
    protected final String httpMethodName;
    private NettyHttpParameters httpParameters;
    private Optional<MediaType> mediaType;
    private Charset charset;
    private Optional<Locale> locale;
    private String path;
    private Collection<MediaType> accept;

    public AbstractNettyHttpRequest(io.netty.handler.codec.http.HttpRequest nettyRequest, ConversionService conversionService) {
        this.nettyRequest = nettyRequest;
        this.conversionService = conversionService;
        String fullUri = nettyRequest.uri();
        this.uri = URI.create(fullUri);
        this.httpMethodName = nettyRequest.method().name();
        this.httpMethod = HttpMethod.parse((String)this.httpMethodName);
    }

    @Override
    @NonNull
    public io.netty.handler.codec.http.HttpRequest toHttpRequest() {
        return this.nettyRequest;
    }

    @Override
    @NonNull
    public FullHttpRequest toFullHttpRequest() {
        if (this.nettyRequest instanceof FullHttpRequest) {
            return (FullHttpRequest)this.nettyRequest;
        }
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(this.nettyRequest.protocolVersion(), this.nettyRequest.method(), this.nettyRequest.uri());
        httpRequest.headers().setAll(this.nettyRequest.headers());
        return httpRequest;
    }

    @Override
    @NonNull
    public StreamedHttpRequest toStreamHttpRequest() {
        if (this.isStream()) {
            return (StreamedHttpRequest)this.nettyRequest;
        }
        if (this.nettyRequest instanceof FullHttpRequest) {
            return new DefaultStreamedHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, this.nettyRequest.method(), this.nettyRequest.uri(), true, (Publisher<HttpContent>)Publishers.just((Object)new DefaultLastHttpContent(((FullHttpRequest)this.nettyRequest).content())));
        }
        return new DefaultStreamedHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, this.nettyRequest.method(), this.nettyRequest.uri(), true, (Publisher<HttpContent>)Publishers.just((Object)LastHttpContent.EMPTY_LAST_CONTENT));
    }

    @Override
    public boolean isStream() {
        return this.nettyRequest instanceof StreamedHttpRequest;
    }

    public HttpVersion getHttpVersion() {
        if (this.nettyRequest.headers().contains((CharSequence)STREAM_ID)) {
            return HttpVersion.HTTP_2_0;
        }
        return HttpVersion.HTTP_1_1;
    }

    public io.netty.handler.codec.http.HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpParameters getParameters() {
        NettyHttpParameters httpParameters = this.httpParameters;
        if (httpParameters == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                httpParameters = this.httpParameters;
                if (httpParameters == null) {
                    this.httpParameters = httpParameters = this.decodeParameters(this.nettyRequest.uri());
                }
            }
        }
        return httpParameters;
    }

    public Collection<MediaType> accept() {
        if (this.accept == null) {
            this.accept = super.accept();
        }
        return this.accept;
    }

    public Optional<MediaType> getContentType() {
        if (this.mediaType == null) {
            this.mediaType = super.getContentType();
        }
        return this.mediaType;
    }

    public Charset getCharacterEncoding() {
        if (this.charset == null) {
            this.charset = this.initCharset(super.getCharacterEncoding());
        }
        return this.charset;
    }

    public Optional<Locale> getLocale() {
        if (this.locale == null) {
            this.locale = super.getLocale();
        }
        return this.locale;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        String path = this.path;
        if (path == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                path = this.path;
                if (path == null) {
                    this.path = path = this.decodePath(this.nettyRequest.uri());
                }
            }
        }
        return path;
    }

    protected abstract Charset initCharset(Charset var1);

    protected QueryStringDecoder createDecoder(String uri) {
        Charset charset = this.getCharacterEncoding();
        return charset != null ? new QueryStringDecoder(uri, charset) : new QueryStringDecoder(uri);
    }

    private String decodePath(String uri) {
        QueryStringDecoder queryStringDecoder = this.createDecoder(uri);
        return queryStringDecoder.rawPath();
    }

    private NettyHttpParameters decodeParameters(String uri) {
        QueryStringDecoder queryStringDecoder = this.createDecoder(uri);
        return new NettyHttpParameters(queryStringDecoder.parameters(), this.conversionService, null);
    }

    public String getMethodName() {
        return this.httpMethodName;
    }
}

