/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.KQueueAvailabilityCondition;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Internal
@Requires(classes={KQueue.class}, condition=KQueueAvailabilityCondition.class)
@Named(value="native")
@BootstrapContextCompatible
public class KQueueEventLoopGroupFactory
implements EventLoopGroupFactory {
    @Override
    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return KQueueEventLoopGroupFactory.withIoRatio(new KQueueEventLoopGroup(threads, threadFactory), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return KQueueEventLoopGroupFactory.withIoRatio(new KQueueEventLoopGroup(threads, executor), ioRatio);
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return KQueueServerSocketChannel.class;
    }

    public KQueueServerSocketChannel serverSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new KQueueServerSocketChannel();
    }

    @Override
    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return KQueueSocketChannel.class;
    }

    @Override
    public SocketChannel clientSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new KQueueSocketChannel();
    }

    private static KQueueEventLoopGroup withIoRatio(KQueueEventLoopGroup group, @Nullable Integer ioRatio) {
        if (ioRatio != null) {
            group.setIoRatio(ioRatio.intValue());
        }
        return group;
    }
}

