/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.websocket;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.MediaType;
import io.micronaut.http.netty.websocket.NettyRxWebSocketSession;
import io.micronaut.http.netty.websocket.WebSocketMessageEncoder;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.websocket.WebSocketBroadcaster;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.Attribute;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.util.function.Predicate;
import javax.inject.Singleton;

@Singleton
@Requires(beans={WebSocketSessionRepository.class})
public class NettyServerWebSocketBroadcaster
implements WebSocketBroadcaster {
    private final WebSocketMessageEncoder webSocketMessageEncoder;
    private final WebSocketSessionRepository webSocketSessionRepository;

    public NettyServerWebSocketBroadcaster(WebSocketMessageEncoder webSocketMessageEncoder, WebSocketSessionRepository webSocketSessionRepository) {
        this.webSocketMessageEncoder = webSocketMessageEncoder;
        this.webSocketSessionRepository = webSocketSessionRepository;
    }

    public <T> void broadcastSync(T message, MediaType mediaType, Predicate<WebSocketSession> filter) {
        WebSocketFrame frame = this.webSocketMessageEncoder.encodeMessage(message, mediaType);
        try {
            this.webSocketSessionRepository.getChannelGroup().writeAndFlush((Object)frame, ch -> {
                Attribute attr = ch.attr(NettyRxWebSocketSession.WEB_SOCKET_SESSION_KEY);
                NettyRxWebSocketSession s = (NettyRxWebSocketSession)attr.get();
                return s != null && s.isOpen() && filter.test((WebSocketSession)s);
            }).sync();
        }
        catch (InterruptedException e) {
            throw new WebSocketSessionException("Broadcast Interrupted");
        }
    }

    public <T> Flowable<T> broadcast(T message, MediaType mediaType, Predicate<WebSocketSession> filter) {
        return Flowable.create(emitter -> {
            try {
                WebSocketFrame frame = this.webSocketMessageEncoder.encodeMessage(message, mediaType);
                this.webSocketSessionRepository.getChannelGroup().writeAndFlush((Object)frame, ch -> {
                    Attribute attr = ch.attr(NettyRxWebSocketSession.WEB_SOCKET_SESSION_KEY);
                    NettyRxWebSocketSession s = (NettyRxWebSocketSession)attr.get();
                    return s != null && s.isOpen() && filter.test((WebSocketSession)s);
                }).addListener(future -> {
                    if (future.isSuccess()) {
                        emitter.onNext(message);
                        emitter.onComplete();
                    } else {
                        Throwable cause = future.cause();
                        emitter.onError((Throwable)new WebSocketSessionException("Broadcast Failure: " + cause.getMessage(), cause));
                    }
                });
            }
            catch (Throwable e) {
                emitter.onError((Throwable)new WebSocketSessionException("Broadcast Failure: " + e.getMessage(), e));
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }
}

