/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.netty.content.HttpContentUtil;
import io.netty.handler.codec.http.HttpContent;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
public final class JsonSubscriber {
    public static Flux<HttpContent> lift(Publisher<HttpContent> publisher) {
        final HttpContent closeBracket = HttpContentUtil.closeBracket();
        return Flux.from(publisher).concatWithValues((Object[])new HttpContent[]{closeBracket}).map((Function)new Function<HttpContent, HttpContent>(){
            boolean empty = true;

            @Override
            public HttpContent apply(HttpContent httpContent) {
                if (this.empty) {
                    this.empty = false;
                    return HttpContentUtil.prefixOpenBracket(httpContent);
                }
                if (httpContent != closeBracket) {
                    return HttpContentUtil.prefixComma(httpContent);
                }
                return httpContent;
            }
        });
    }
}

