/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.http.server.netty.binders.NettyBodyAnnotationBinder;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class NettyPublisherBodyBinder
implements NonBlockingBodyArgumentBinder<Publisher<?>> {
    public static final String MSG_CONVERT_DEBUG = "Cannot convert message for argument [{}] and value: {}";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private static final Argument<Publisher<?>> TYPE = Argument.of(Publisher.class);
    private final NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder;

    NettyPublisherBodyBinder(NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder) {
        this.nettyBodyAnnotationBinder = nettyBodyAnnotationBinder;
    }

    public Argument<Publisher<?>> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<Publisher<?>> bind(ArgumentConversionContext<Publisher<?>> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            Object t;
            Optional reader;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            ByteBody rootBody = nhr.byteBody();
            if (rootBody.expectedLength().orElse(-1L) == 0L) {
                return ArgumentBinder.BindingResult.empty();
            }
            Argument targetType = context.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            MediaType mediaType = nhr.getContentType().orElse(null);
            if (!Publishers.isSingle((Class)context.getArgument().getType()) && !context.getArgument().isSpecifiedSingle() && mediaType != null && (reader = this.nettyBodyAnnotationBinder.bodyHandlerRegistry.findReader(targetType, List.of(mediaType))).isPresent() && (t = reader.get()) instanceof ChunkedMessageBodyReader) {
                ChunkedMessageBodyReader piecewise = (ChunkedMessageBodyReader)t;
                Publisher pub = piecewise.readChunked(targetType, mediaType, (Headers)nhr.getHeaders(), rootBody.toByteBufferPublisher());
                return () -> Optional.of(pub);
            }
            ExecutionFlow flow = InternalByteBody.bufferFlow((ByteBody)rootBody).map(bytes -> {
                Optional<Object> value;
                try {
                    value = this.nettyBodyAnnotationBinder.transform(nhr, (ArgumentConversionContext<Object>)context.with(targetType), (AvailableByteBody)bytes);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return value.orElseThrow(() -> NettyPublisherBodyBinder.extractError(null, context));
            });
            Publisher future = ReactiveExecutionFlow.toPublisher(() -> flow);
            return () -> Optional.of(future);
        }
        return ArgumentBinder.BindingResult.empty();
    }

    static RuntimeException extractError(Object message, ArgumentConversionContext<?> conversionContext) {
        Optional lastError = conversionContext.getLastError();
        if (lastError.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(MSG_CONVERT_DEBUG, (Object)conversionContext.getArgument(), lastError.get());
            }
            return new ConversionErrorException(conversionContext.getArgument(), (ConversionError)lastError.get());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(MSG_CONVERT_DEBUG, (Object)conversionContext.getArgument(), message);
        }
        return UnsatisfiedRouteException.create((Argument)conversionContext.getArgument());
    }
}

