/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.web.router.resource.StaticResourceConfiguration;
import javax.inject.Singleton;

@Singleton
class StaticResourceContextPathListener
implements BeanCreatedEventListener<StaticResourceConfiguration> {
    private final HttpServerConfiguration httpServerConfiguration;

    StaticResourceContextPathListener(HttpServerConfiguration httpServerConfiguration) {
        this.httpServerConfiguration = httpServerConfiguration;
    }

    public StaticResourceConfiguration onCreated(BeanCreatedEvent<StaticResourceConfiguration> event) {
        String contextPath = this.httpServerConfiguration.getContextPath();
        if (contextPath == null) {
            return (StaticResourceConfiguration)event.getBean();
        }
        StaticResourceConfiguration configuration = (StaticResourceConfiguration)event.getBean();
        configuration.setMapping(StringUtils.prependUri((String)contextPath, (String)configuration.getMapping()));
        return configuration;
    }
}

