/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes.rules;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.Named;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MissingParameterRule
implements RouteValidationRule {
    @Override
    public RouteValidationResult validate(List<UriMatchTemplate> templates, ParameterElement[] parameters, MethodElement method) {
        Set variables = templates.stream().flatMap(t -> t.getVariableNames().stream()).collect(Collectors.toSet());
        Set routeVariables = Arrays.stream(parameters).map(Element::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        routeVariables.addAll(Arrays.stream(parameters).filter(p -> p.hasAnnotation("io.micronaut.http.annotation.Body")).map(ParameterElement::getType).filter(Objects::nonNull).flatMap(MissingParameterRule::findProperties).map(Named::getName).collect(Collectors.toList()));
        routeVariables.addAll(Arrays.stream(parameters).filter(p -> p.hasAnnotation("io.micronaut.http.annotation.RequestBean")).map(ParameterElement::getType).flatMap(MissingParameterRule::findProperties).filter(p -> p.getAnnotationMetadata().hasStereotype(Bindable.class)).map(p -> p.getAnnotationMetadata().stringValue(Bindable.class).orElse(p.getName())).collect(Collectors.toSet()));
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (String v : variables) {
            if (routeVariables.contains(v)) continue;
            errorMessages.add(String.format("The route declares a uri variable named [%s], but no corresponding method argument is present", v));
        }
        return new RouteValidationResult(errorMessages.toArray(new String[0]));
    }

    private static Stream<? extends AnnotatedElement> findProperties(ClassElement t) {
        Optional primaryConstructor;
        if (t.isRecord() && (primaryConstructor = t.getPrimaryConstructor()).isPresent()) {
            return Arrays.stream(((MethodElement)primaryConstructor.get()).getParameters());
        }
        return t.getBeanProperties().stream();
    }
}

