/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.testing.compile.JavaFileObjects;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import io.micronaut.annotation.processing.test.JavaParser;
import java.io.File;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class Parser {
    private static final TreeScanner<Boolean, Boolean> HAS_ERRONEOUS_NODE = new TreeScanner<Boolean, Boolean>(){

        @Override
        public Boolean visitErroneous(ErroneousTree node, Boolean p) {
            return true;
        }

        @Override
        public Boolean scan(Iterable<? extends Tree> nodes, Boolean p) {
            for (Tree node : (Iterable)MoreObjects.firstNonNull(nodes, Collections.emptyList())) {
                if (!Parser.isTrue(this.scan(node, p))) continue;
                return true;
            }
            return p;
        }

        @Override
        public Boolean scan(Tree tree, Boolean p) {
            return Parser.isTrue(p) ? p : (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return Parser.isTrue(r1) || Parser.isTrue(r2);
        }
    };

    public static boolean hasErrorNode(Tree tree) {
        return Parser.isTrue(HAS_ERRONEOUS_NODE.scan(tree, (Boolean)false));
    }

    public static Iterable<? extends Element> parse(JavaFileObject ... sources) {
        JavaParser javaParser = new JavaParser();
        return javaParser.parse(sources);
    }

    public static Iterable<? extends Element> parseLines(String className, String ... lines) {
        return Parser.parse(JavaFileObjects.forSourceLines((String)(className.replace('.', File.separatorChar) + ".java"), (String[])lines));
    }

    public static Iterable<? extends JavaFileObject> generate(String className, String code) {
        return Parser.generate(JavaFileObjects.forSourceString((String)className, (String)code));
    }

    public static Iterable<? extends JavaFileObject> generate(JavaFileObject ... sources) {
        return new JavaParser().generate(sources);
    }

    private static boolean isTrue(Boolean p) {
        return Boolean.TRUE.equals(p);
    }

    public static final class ParseResult {
        private final ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnostics;
        private final ImmutableList<? extends CompilationUnitTree> compilationUnits;
        private final Trees trees;

        ParseResult(ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnostics, Iterable<? extends CompilationUnitTree> compilationUnits, Trees trees) {
            this.trees = trees;
            this.compilationUnits = ImmutableList.copyOf(compilationUnits);
            this.diagnostics = diagnostics;
        }

        public ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnosticsByKind() {
            return this.diagnostics;
        }

        public Iterable<? extends CompilationUnitTree> compilationUnits() {
            return this.compilationUnits;
        }

        public Trees trees() {
            return this.trees;
        }
    }
}

