/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.annotation.processing.AnnotationProcessingOutputVisitor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.GenericUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

abstract class AbstractInjectAnnotationProcessor
extends AbstractProcessor {
    protected static final String MICRONAUT_PROCESSING_INCREMENTAL = "micronaut.processing.incremental";
    protected static final String MICRONAUT_PROCESSING_ANNOTATIONS = "micronaut.processing.annotations";
    protected static final String GRADLE_PROCESSING_AGGREGATING = "org.gradle.annotation.processing.aggregating";
    protected static final String GRADLE_PROCESSING_ISOLATING = "org.gradle.annotation.processing.isolating";
    protected Messager messager;
    protected Filer filer;
    protected Elements elementUtils;
    protected Types typeUtils;
    protected AnnotationUtils annotationUtils;
    protected GenericUtils genericUtils;
    protected ModelUtils modelUtils;
    protected MutableConvertibleValues<Object> visitorAttributes = new MutableConvertibleValuesMap();
    protected AnnotationProcessingOutputVisitor classWriterOutputVisitor;
    protected JavaVisitorContext javaVisitorContext;
    private boolean incremental = false;
    private final Set<String> supportedAnnotationTypes = new HashSet<String>(5);

    AbstractInjectAnnotationProcessor() {
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latest();
        if (sourceVersion.ordinal() <= 15) {
            if (sourceVersion.ordinal() >= 8) {
                return sourceVersion;
            }
            return SourceVersion.RELEASE_8;
        }
        return SourceVersion.values()[15];
    }

    @Override
    public Set<String> getSupportedOptions() {
        Set<String> options = this.incremental ? CollectionUtils.setOf((Object[])new String[]{this.getIncrementalProcessorType()}) : new HashSet<String>(5);
        options.addAll(super.getSupportedOptions());
        return options;
    }

    protected String getIncrementalProcessorType() {
        return GRADLE_PROCESSING_ISOLATING;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (this.incremental) {
            Set types = CollectionUtils.setOf((Object[])new String[]{"javax.inject.*", "io.micronaut.*"});
            types.addAll(this.supportedAnnotationTypes);
            Set mappedAnnotationNames = AbstractAnnotationMetadataBuilder.getMappedAnnotationNames();
            for (String mappedAnnotationName : mappedAnnotationNames) {
                if (mappedAnnotationName.contains("Nullable") || mappedAnnotationName.contains("NotNull")) continue;
                types.add(mappedAnnotationName);
            }
            return types;
        }
        return Collections.singleton("*");
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        String annotations;
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.classWriterOutputVisitor = new AnnotationProcessingOutputVisitor(this.filer);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.modelUtils = new ModelUtils(this.elementUtils, this.typeUtils);
        this.genericUtils = new GenericUtils(this.elementUtils, this.typeUtils, this.modelUtils);
        this.annotationUtils = new AnnotationUtils(processingEnv, this.elementUtils, this.messager, this.typeUtils, this.modelUtils, this.genericUtils, this.filer, this.visitorAttributes);
        this.javaVisitorContext = this.newVisitorContext(processingEnv);
        this.incremental = this.isIncremental(processingEnv);
        if (this.incremental && (annotations = processingEnv.getOptions().get(MICRONAUT_PROCESSING_ANNOTATIONS)) != null) {
            String[] tokens = annotations.split(",");
            this.supportedAnnotationTypes.addAll(Arrays.asList(tokens));
        }
    }

    @NonNull
    protected JavaVisitorContext newVisitorContext(@NonNull ProcessingEnvironment processingEnv) {
        return new JavaVisitorContext(processingEnv, this.messager, this.elementUtils, this.annotationUtils, this.typeUtils, this.modelUtils, this.genericUtils, this.filer, this.visitorAttributes);
    }

    protected final void error(Element e, String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    protected final void error(String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    protected final void warning(Element e, String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), e);
    }

    protected final void warning(String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    protected final void note(Element e, String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args), e);
    }

    protected final void note(String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    private void illegalState() {
        throw new IllegalStateException("No messager set. Ensure processing environment is initialized");
    }

    protected boolean isIncremental(@NonNull ProcessingEnvironment processingEnv) {
        Map<String, String> options = processingEnv.getOptions();
        String v = options.get(MICRONAUT_PROCESSING_INCREMENTAL);
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return false;
    }
}

