/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.tracing.brave.instrument.http.AbstractBraveTracingFilter;
import io.micronaut.tracing.brave.instrument.http.HttpServerTracingPublisher;
import io.opentracing.Tracer;
import org.reactivestreams.Publisher;

@Filter(value={"${tracing.http.server.path:/**}"})
@Requires(beans={HttpServerHandler.class})
public class BraveTracingServerFilter
extends AbstractBraveTracingFilter
implements HttpServerFilter {
    private final HttpServerHandler<HttpRequest<?>, MutableHttpResponse<?>> serverHandler;
    private final TraceContext.Extractor<HttpHeaders> extractor;
    private final Tracer openTracer;

    public BraveTracingServerFilter(HttpTracing httpTracing, Tracer openTracer, HttpServerHandler<HttpRequest<?>, MutableHttpResponse<?>> serverHandler) {
        super(httpTracing);
        this.openTracer = openTracer;
        this.serverHandler = serverHandler;
        this.extractor = httpTracing.tracing().propagation().extractor(ConvertibleMultiValues::get);
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Span span = this.serverHandler.handleReceive(this.extractor, (Object)request.getHeaders(), request);
        return new HttpServerTracingPublisher(chain.proceed(request), request, this.serverHandler, this.httpTracing, this.openTracer, span);
    }
}

