/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.tracing.instrument.http.TraceRequestAttributes;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class HttpClientTracingPublisher
implements Publisher<HttpResponse<?>> {
    private static final int HTTP_SUCCESS_CODE_UPPER_LIMIT = 299;
    private final Publisher<HttpResponse<?>> publisher;
    private final HttpClientHandler<HttpRequest<?>, HttpResponse<?>> clientHandler;
    private final TraceContext.Injector<MutableHttpHeaders> injector;
    private final MutableHttpRequest<?> request;
    private final Tracer tracer;

    HttpClientTracingPublisher(Publisher<HttpResponse<?>> publisher, MutableHttpRequest<?> request, HttpClientHandler<HttpRequest<?>, HttpResponse<?>> clientHandler, HttpTracing httpTracing) {
        this.publisher = publisher;
        this.request = request;
        this.clientHandler = clientHandler;
        Tracing tracing = httpTracing.tracing();
        this.tracer = tracing.tracer();
        this.injector = tracing.propagation().injector(MutableHttpHeaders::add);
    }

    public void subscribe(final Subscriber<? super HttpResponse<?>> actual) {
        final Span span = this.clientHandler.handleSend(this.injector, (Object)this.request.getHeaders(), this.request);
        this.request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        final String serviceName = this.request.getAttribute((CharSequence)HttpAttributes.SERVICE_ID, String.class).orElse(null);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            this.publisher.subscribe(new Subscriber<HttpResponse<?>>(){

                public void onSubscribe(Subscription s) {
                    try (Tracer.SpanInScope ignored = HttpClientTracingPublisher.this.tracer.withSpanInScope(span);){
                        actual.onSubscribe(s);
                    }
                }

                public void onNext(HttpResponse<?> response) {
                    try (Tracer.SpanInScope ignored = HttpClientTracingPublisher.this.tracer.withSpanInScope(span);){
                        HttpClientTracingPublisher.this.configureAttributes(response);
                        HttpClientTracingPublisher.this.configureSpan(span, serviceName);
                        HttpStatus status = response.getStatus();
                        if (status.getCode() > 299) {
                            span.tag("http.status_code", String.valueOf(status.getCode()));
                        }
                        HttpClientTracingPublisher.this.clientHandler.handleReceive(response, null, span);
                        actual.onNext(response);
                    }
                }

                public void onError(Throwable error) {
                    try (Tracer.SpanInScope ignored = HttpClientTracingPublisher.this.tracer.withSpanInScope(span);){
                        HttpClientTracingPublisher.this.configureSpan(span, serviceName);
                        if (error instanceof HttpClientResponseException) {
                            HttpClientResponseException e = (HttpClientResponseException)error;
                            HttpResponse response = e.getResponse();
                            HttpClientTracingPublisher.this.configureAttributes(response);
                            HttpClientTracingPublisher.this.clientHandler.handleReceive((Object)response, (Throwable)e, span);
                        } else {
                            span.error(error);
                            span.finish();
                        }
                        actual.onError(error);
                    }
                }

                public void onComplete() {
                    actual.onComplete();
                }
            });
        }
    }

    private void configureSpan(Span span, String serviceName) {
        span.kind(Span.Kind.CLIENT);
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            span.remoteServiceName(serviceName);
        }
        span.tag("http.method", this.request.getMethod().name());
        String path = this.request.getPath();
        span.tag("http.path", path);
    }

    private void configureAttributes(HttpResponse<?> response) {
        Optional routeTemplate = this.request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE);
        routeTemplate.ifPresent(o -> response.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, o));
        response.setAttribute((CharSequence)HttpAttributes.METHOD_NAME, (Object)this.request.getMethod().name());
    }
}

