/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.tracing.instrument.http.TraceRequestAttributes;
import io.micronaut.tracing.instrument.util.ScopePropagationPublisher;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class HttpServerTracingPublisher
implements Publisher<MutableHttpResponse<?>> {
    private static final int HTTP_SUCCESS_CODE_UPPER_LIMIT = 299;
    private final Publisher<MutableHttpResponse<?>> publisher;
    private final HttpServerHandler<HttpRequest<?>, MutableHttpResponse<?>> serverHandler;
    private final HttpRequest<?> request;
    private final Tracer tracer;
    private final io.opentracing.Tracer openTracer;
    private final Span initialSpan;

    HttpServerTracingPublisher(Publisher<MutableHttpResponse<?>> publisher, HttpRequest<?> request, HttpServerHandler<HttpRequest<?>, MutableHttpResponse<?>> serverHandler, HttpTracing httpTracing, io.opentracing.Tracer openTracer, Span initialSpan) {
        this.publisher = publisher;
        this.request = request;
        this.initialSpan = initialSpan;
        this.serverHandler = serverHandler;
        Tracing tracing = httpTracing.tracing();
        this.tracer = tracing.tracer();
        this.openTracer = openTracer;
    }

    public void subscribe(final Subscriber<? super MutableHttpResponse<?>> actual) {
        final Span span = this.initialSpan;
        Optional routeTemplate = this.request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE);
        routeTemplate.ifPresent(o -> span.name(this.request.getMethod() + " " + o.toString()));
        this.request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            this.publisher.subscribe(new Subscriber<MutableHttpResponse<?>>(){

                public void onSubscribe(Subscription s) {
                    try (Tracer.SpanInScope ignored = HttpServerTracingPublisher.this.tracer.withSpanInScope(span);){
                        actual.onSubscribe(s);
                    }
                }

                public void onNext(MutableHttpResponse<?> response) {
                    try (Tracer.SpanInScope ignored = HttpServerTracingPublisher.this.tracer.withSpanInScope(span);){
                        Object o;
                        Optional body = response.getBody();
                        if (body.isPresent() && Publishers.isConvertibleToPublisher(o = body.get())) {
                            Class<?> type = o.getClass();
                            Publisher resultPublisher = (Publisher)Publishers.convertPublisher(o, Publisher.class);
                            ScopePropagationPublisher scopedPublisher = new ScopePropagationPublisher(resultPublisher, HttpServerTracingPublisher.this.openTracer, HttpServerTracingPublisher.this.openTracer.activeSpan());
                            response.body(Publishers.convertPublisher(scopedPublisher, type));
                        }
                        HttpServerTracingPublisher.this.configureAttributes(response);
                        HttpServerTracingPublisher.this.configureSpan(span);
                        HttpStatus status = response.getStatus();
                        if (status.getCode() > 299) {
                            span.tag("http.status_code", String.valueOf(status.getCode()));
                        }
                        HttpServerTracingPublisher.this.serverHandler.handleSend(response, null, span);
                        actual.onNext(response);
                    }
                }

                public void onError(Throwable error) {
                    try (Tracer.SpanInScope ignored = HttpServerTracingPublisher.this.tracer.withSpanInScope(span);){
                        HttpServerTracingPublisher.this.configureSpan(span);
                        if (error instanceof HttpStatusException) {
                            int code = ((HttpStatusException)error).getStatus().getCode();
                            span.tag("http.status_code", String.valueOf(code));
                        } else {
                            span.tag("http.status_code", String.valueOf(500));
                        }
                        span.error(error);
                        span.finish();
                        actual.onError(error);
                    }
                }

                public void onComplete() {
                    actual.onComplete();
                }
            });
        }
    }

    private void configureSpan(Span span) {
        span.kind(Span.Kind.SERVER);
        span.tag("http.method", this.request.getMethod().name());
        span.tag("http.path", this.request.getPath());
    }

    private void configureAttributes(HttpResponse<?> response) {
        Optional routeTemplate = this.request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE);
        routeTemplate.ifPresent(o -> response.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, o));
        response.setAttribute((CharSequence)HttpAttributes.METHOD_NAME, (Object)this.request.getMethod().name());
    }
}

