/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import javax.inject.Singleton;
import zipkin2.Endpoint;

@Factory
@Requirements(value={@Requires(beans={Tracing.class}), @Requires(classes={HttpTracing.class})})
public class HttpTracingFactory {
    @Singleton
    @Requires(missingBeans={HttpTracing.class})
    HttpTracing httpTracing(Tracing tracing) {
        return HttpTracing.create((Tracing)tracing);
    }

    @Singleton
    HttpClientHandler<HttpRequest<?>, HttpResponse<?>> httpClientHandler(HttpTracing httpTracing) {
        return HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpClientAdapter<HttpRequest<?>, HttpResponse<?>>(){

            public String method(HttpRequest<?> request) {
                return request.getMethod().name();
            }

            public String url(HttpRequest<?> request) {
                return request.getUri().toString();
            }

            public String requestHeader(HttpRequest<?> request, String name) {
                return (String)request.getHeaders().get((CharSequence)name);
            }

            public Integer statusCode(HttpResponse<?> response) {
                return response.getStatus().getCode();
            }

            public boolean parseServerIpAndPort(HttpRequest<?> request, Endpoint.Builder builder) {
                InetAddress address = request.getServerAddress().getAddress();
                return builder.parseIp(address);
            }

            public String methodFromResponse(HttpResponse<?> httpResponse) {
                return httpResponse.getAttribute((CharSequence)HttpAttributes.METHOD_NAME, String.class).orElseGet(() -> super.methodFromResponse((Object)httpResponse));
            }

            public String route(HttpResponse<?> response) {
                Optional value = response.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class);
                return value.orElseGet(() -> super.route((Object)response));
            }
        });
    }

    @Singleton
    HttpServerHandler<HttpRequest<?>, HttpResponse<?>> httpServerHandler(HttpTracing httpTracing) {
        return HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)new HttpServerAdapter<HttpRequest<?>, HttpResponse<?>>(){

            public String method(HttpRequest<?> request) {
                return request.getMethod().name();
            }

            public String url(HttpRequest<?> request) {
                return request.getUri().toString();
            }

            public String requestHeader(HttpRequest<?> request, String name) {
                return (String)request.getHeaders().get((CharSequence)name);
            }

            public Integer statusCode(HttpResponse<?> response) {
                return response.getStatus().getCode();
            }

            public String route(HttpResponse<?> response) {
                Optional value = response.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class);
                return value.orElseGet(() -> super.route((Object)response));
            }

            public String methodFromResponse(HttpResponse<?> httpResponse) {
                return httpResponse.getAttribute((CharSequence)HttpAttributes.METHOD_NAME, String.class).orElse(null);
            }

            public boolean parseClientAddress(HttpRequest<?> httpRequest, Endpoint.Builder builder) {
                InetSocketAddress remoteAddress = httpRequest.getRemoteAddress();
                return builder.parseIp(remoteAddress.getAddress());
            }
        });
    }
}

