/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.sender;

import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.exceptions.NoAvailableServiceException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancerResolver;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;

public final class HttpClientSender
extends Sender {
    private final Encoding encoding;
    private final int messageMaxBytes;
    private final boolean compressionEnabled;
    private final URI endpoint;
    private final Provider<LoadBalancerResolver> loadBalancerResolver;
    private final HttpClientConfiguration clientConfiguration;
    private HttpClient httpClient;

    private HttpClientSender(Encoding encoding, int messageMaxBytes, boolean compressionEnabled, HttpClientConfiguration clientConfiguration, Provider<LoadBalancerResolver> loadBalancerResolver, String path) {
        this.loadBalancerResolver = loadBalancerResolver;
        this.clientConfiguration = clientConfiguration;
        this.encoding = encoding;
        this.messageMaxBytes = messageMaxBytes;
        this.compressionEnabled = compressionEnabled;
        this.endpoint = path != null ? URI.create(path) : URI.create("/api/v2/spans");
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        this.initHttpClient();
        if (this.httpClient != null && this.httpClient.isRunning()) {
            return new HttpCall(this.httpClient, this.endpoint, this.compressionEnabled, encodedSpans);
        }
        throw new IllegalStateException("HTTP Client Closed");
    }

    public CheckResult check() {
        this.initHttpClient();
        if (this.httpClient == null) {
            return CheckResult.failed((Throwable)new NoAvailableServiceException("zipkin"));
        }
        try {
            HttpResponse response = this.httpClient.toBlocking().exchange((HttpRequest)HttpRequest.POST((URI)this.endpoint, Collections.emptyList()));
            if (response.getStatus().getCode() < HttpStatus.MULTIPLE_CHOICES.getCode()) {
                return CheckResult.OK;
            }
            throw new IllegalStateException("check response failed: " + response);
        }
        catch (Exception e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    private void initHttpClient() {
        if (this.httpClient == null) {
            Optional loadBalancer = ((LoadBalancerResolver)this.loadBalancerResolver.get()).resolve(new String[]{"zipkin"});
            this.httpClient = loadBalancer.map(lb -> new DefaultHttpClient(lb, this.clientConfiguration)).orElse(null);
        }
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public static class Builder {
        public static final String DEFAULT_PATH = "/api/v2/spans";
        public static final String DEFAULT_SERVER_URL = "http://localhost:9411";
        private Encoding encoding = Encoding.JSON;
        private int messageMaxBytes = 5120;
        private String path = "/api/v2/spans";
        private boolean compressionEnabled = true;
        private List<URI> servers = Collections.singletonList(URI.create("http://localhost:9411"));
        private final HttpClientConfiguration clientConfiguration;

        public Builder(HttpClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
        }

        public List<URI> getServers() {
            return this.servers;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding != null) {
                this.encoding = encoding;
            }
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public Builder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder server(URI endpoint) {
            if (endpoint != null) {
                this.servers = Collections.singletonList(endpoint);
            }
            return this;
        }

        public Builder url(URI endpoint) {
            return this.server(endpoint);
        }

        public Builder urls(List<URI> urls) {
            if (CollectionUtils.isNotEmpty(urls)) {
                this.servers = Collections.unmodifiableList(urls);
            }
            return this;
        }

        public HttpClientSender build(Provider<LoadBalancerResolver> loadBalancerResolver) {
            return new HttpClientSender(this.encoding, this.messageMaxBytes, this.compressionEnabled, this.clientConfiguration, loadBalancerResolver, this.path);
        }
    }

    private static class HttpCall
    extends Call<Void> {
        private final HttpClient httpClient;
        private final URI endpoint;
        private final boolean compressionEnabled;
        private final List<byte[]> encodedSpans;
        private AtomicReference<Subscription> subscription = new AtomicReference();
        private AtomicBoolean cancelled = new AtomicBoolean(false);

        HttpCall(HttpClient httpClient, URI endpoint, boolean compressionEnabled, List<byte[]> encodedSpans) {
            this.httpClient = httpClient;
            this.endpoint = endpoint;
            this.compressionEnabled = compressionEnabled;
            this.encodedSpans = encodedSpans;
        }

        public Void execute() throws IOException {
            BlockingHttpClient blockingHttpClient = this.httpClient.toBlocking();
            HttpResponse response = blockingHttpClient.exchange(this.prepareRequest());
            if (response.getStatus().getCode() >= HttpStatus.BAD_REQUEST.getCode()) {
                throw new IllegalStateException("Response return invalid status code: " + response.getStatus());
            }
            return null;
        }

        public void enqueue(final Callback<Void> callback) {
            Publisher publisher = this.httpClient.exchange(this.prepareRequest());
            publisher.subscribe((Subscriber)new Subscriber<HttpResponse<ByteBuffer>>(){

                public void onSubscribe(Subscription s) {
                    subscription.set(s);
                    s.request(1L);
                }

                public void onNext(HttpResponse<ByteBuffer> response) {
                    if (response.getStatus().getCode() >= HttpStatus.BAD_REQUEST.getCode()) {
                        callback.onError((Throwable)new IllegalStateException("Response return invalid status code: " + response.getStatus()));
                    } else {
                        callback.onSuccess(null);
                    }
                }

                public void onError(Throwable t) {
                    callback.onError(t);
                }

                public void onComplete() {
                }
            });
        }

        public void cancel() {
            Subscription s = this.subscription.get();
            if (s != null) {
                this.cancelled.set(true);
                s.cancel();
            }
        }

        public boolean isCanceled() {
            Subscription s = this.subscription.get();
            if (s != null) {
                return this.cancelled.get();
            }
            return false;
        }

        public Call<Void> clone() {
            return new HttpCall(this.httpClient, this.endpoint, this.compressionEnabled, this.encodedSpans);
        }

        protected MutableHttpRequest<Flowable<Object>> prepareRequest() {
            return HttpRequest.POST((URI)this.endpoint, this.spanFlowable());
        }

        private Flowable<Object> spanFlowable() {
            return Flowable.create(emitter -> {
                for (byte[] encodedSpan : this.encodedSpans) {
                    emitter.onNext((Object)encodedSpan);
                }
                emitter.onComplete();
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
        }
    }
}

