/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.scheduling;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import io.micronaut.scheduling.instrument.InstrumentedScheduledExecutorService;
import io.micronaut.tracing.instrument.util.TracingCallable;
import io.micronaut.tracing.instrument.util.TracingRunnable;
import io.opentracing.Tracer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(property="tracing.instrument-threads", value="true", defaultValue="false")})
public class ExecutorServiceInstrumenter
implements BeanCreatedEventListener<ExecutorService> {
    public static final String PROPERTY_INSTRUMENT_THREADS = "tracing.instrument-threads";
    private final Tracer tracer;

    public ExecutorServiceInstrumenter(Tracer tracer) {
        this.tracer = tracer;
    }

    public ExecutorService onCreated(BeanCreatedEvent<ExecutorService> event) {
        final ExecutorService executorService = (ExecutorService)event.getBean();
        if (executorService instanceof ScheduledExecutorService) {
            return new InstrumentedScheduledExecutorService(){

                public ScheduledExecutorService getTarget() {
                    return (ScheduledExecutorService)executorService;
                }

                public <T> Callable<T> instrument(Callable<T> task) {
                    return new TracingCallable<T>(task, ExecutorServiceInstrumenter.this.tracer);
                }

                public Runnable instrument(Runnable command) {
                    return new TracingRunnable(command, ExecutorServiceInstrumenter.this.tracer);
                }
            };
        }
        return new InstrumentedExecutorService(){

            public ExecutorService getTarget() {
                return executorService;
            }

            public <T> Callable<T> instrument(Callable<T> task) {
                return new TracingCallable<T>(task, ExecutorServiceInstrumenter.this.tracer);
            }

            public Runnable instrument(Runnable command) {
                return new TracingRunnable(command, ExecutorServiceInstrumenter.this.tracer);
            }
        };
    }
}

