/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.scheduling;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.tracing.instrument.util.TracingRunnable;
import io.opentracing.Tracer;
import java.util.concurrent.ThreadFactory;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(property="tracing.instrument-threads", value="true", defaultValue="false")})
public class ThreadFactoryInstrumenter
implements BeanCreatedEventListener<ThreadFactory> {
    private final Tracer tracer;

    public ThreadFactoryInstrumenter(Tracer tracer) {
        this.tracer = tracer;
    }

    public ThreadFactory onCreated(BeanCreatedEvent<ThreadFactory> event) {
        ThreadFactory original = (ThreadFactory)event.getBean();
        return r -> original.newThread(new TracingRunnable(r, this.tracer));
    }
}

