/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.util;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import io.micronaut.scheduling.instrument.InstrumentedScheduledExecutorService;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.inject.Singleton;
import org.slf4j.MDC;

@Singleton
@Requires(classes={MDC.class})
@Internal
public final class MdcInstrumenter
implements Function<Runnable, Runnable>,
RunnableInstrumenter,
ReactiveInstrumenter,
BeanCreatedEventListener<ExecutorService> {
    @Override
    public Runnable apply(Runnable runnable) {
        Map contextMap = MDC.getCopyOfContextMap();
        if (contextMap != null && !contextMap.isEmpty()) {
            return this.passMdcTo(runnable, contextMap);
        }
        return runnable;
    }

    @Override
    private <T> Callable<T> apply(Callable<T> callable) {
        Map copyOfContextMap = MDC.getCopyOfContextMap();
        if (copyOfContextMap != null && !copyOfContextMap.isEmpty()) {
            return () -> {
                try {
                    MDC.setContextMap((Map)copyOfContextMap);
                    Object v = callable.call();
                    return v;
                }
                finally {
                    MDC.clear();
                }
            };
        }
        return callable;
    }

    public Runnable instrument(Runnable command) {
        return this.apply(command);
    }

    public Optional<RunnableInstrumenter> newInstrumentation() {
        final Map contextMap = MDC.getCopyOfContextMap();
        if (contextMap != null && !contextMap.isEmpty()) {
            return Optional.of(new RunnableInstrumenter(){

                public Runnable instrument(Runnable runnable) {
                    return MdcInstrumenter.this.passMdcTo(runnable, contextMap);
                }
            });
        }
        return Optional.empty();
    }

    private Runnable passMdcTo(Runnable runnable, Map<String, String> contextMap) {
        return () -> {
            try {
                MDC.setContextMap((Map)contextMap);
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        };
    }

    public ExecutorService onCreated(BeanCreatedEvent<ExecutorService> event) {
        final ExecutorService executorService = (ExecutorService)event.getBean();
        if (executorService instanceof ScheduledExecutorService) {
            return new InstrumentedScheduledExecutorService(){

                public ScheduledExecutorService getTarget() {
                    return (ScheduledExecutorService)executorService;
                }

                public <T> Callable<T> instrument(Callable<T> task) {
                    return MdcInstrumenter.this.apply(task);
                }

                public Runnable instrument(Runnable command) {
                    return MdcInstrumenter.this.apply(command);
                }
            };
        }
        return new InstrumentedExecutorService(){

            public ExecutorService getTarget() {
                return executorService;
            }

            public <T> Callable<T> instrument(Callable<T> task) {
                return MdcInstrumenter.this.apply(task);
            }

            public Runnable instrument(Runnable command) {
                return MdcInstrumenter.this.apply(command);
            }
        };
    }
}

