/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.util;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.concurrent.Callable;

public class TracingCallable<V>
implements Callable<V> {
    private final Callable<V> callable;
    private final Tracer tracer;
    private final Span span;

    public TracingCallable(Callable<V> callable, Tracer tracer) {
        this.callable = callable;
        this.tracer = tracer;
        this.span = this.getSpan(tracer);
    }

    @Override
    public V call() throws Exception {
        if (this.span == null || this.span == this.tracer.scopeManager().activeSpan()) {
            return this.callable.call();
        }
        try (Scope ignored = this.tracer.scopeManager().activate(this.span);){
            V v = this.callable.call();
            return v;
        }
    }

    private Span getSpan(Tracer tracer) {
        return tracer.scopeManager().activeSpan();
    }
}

