/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.util;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.tracing.instrument.util.ScopePropagationPublisher;
import io.micronaut.tracing.interceptor.TraceInterceptor;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopScopeManager;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class TracingPublisher<T>
implements Publisher<T> {
    private final Publisher<T> publisher;
    private final Tracer tracer;
    private final Tracer.SpanBuilder spanBuilder;
    private final Span parentSpan;
    private final boolean isSingle;

    public TracingPublisher(Publisher<T> publisher, Tracer tracer, String operationName) {
        this(publisher, tracer, tracer.buildSpan(operationName));
    }

    public TracingPublisher(Publisher<T> publisher, Tracer tracer) {
        this(publisher, tracer, (Tracer.SpanBuilder)null);
    }

    public TracingPublisher(Publisher<T> publisher, Tracer tracer, Tracer.SpanBuilder spanBuilder) {
        this(publisher, tracer, spanBuilder, Publishers.isSingle(publisher.getClass()));
    }

    public TracingPublisher(Publisher<T> publisher, Tracer tracer, Tracer.SpanBuilder spanBuilder, boolean isSingle) {
        this.publisher = publisher;
        this.tracer = tracer;
        this.spanBuilder = spanBuilder;
        this.parentSpan = tracer.activeSpan();
        this.isSingle = isSingle;
        if (this.parentSpan != null && spanBuilder != null) {
            spanBuilder.asChildOf(this.parentSpan);
        }
    }

    public void subscribe(final Subscriber<? super T> actual) {
        boolean finishOnClose;
        Span span;
        if (this.spanBuilder != null) {
            span = this.spanBuilder.start();
            finishOnClose = true;
        } else {
            span = this.parentSpan;
            finishOnClose = false;
        }
        if (span != null) {
            final ScopeManager scopeManager = this.tracer.scopeManager();
            try (NoopScopeManager.NoopScope ignored = scopeManager.activeSpan() != span ? scopeManager.activate(span) : NoopScopeManager.NoopScope.INSTANCE;){
                this.publisher.subscribe(new Subscriber<T>(){
                    boolean finished = false;

                    public void onSubscribe(Subscription s) {
                        if (scopeManager.activeSpan() != span) {
                            try (Scope ignored = scopeManager.activate(span);){
                                TracingPublisher.this.doOnSubscribe(span);
                                actual.onSubscribe(s);
                            }
                        } else {
                            TracingPublisher.this.doOnSubscribe(span);
                            actual.onSubscribe(s);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onNext(T object) {
                        boolean finishAfterNext = TracingPublisher.this.isSingle && finishOnClose;
                        try (NoopScopeManager.NoopScope ignored = scopeManager.activeSpan() != span ? scopeManager.activate(span) : NoopScopeManager.NoopScope.INSTANCE;){
                            Object o;
                            MutableHttpResponse response;
                            Optional body;
                            if (object instanceof MutableHttpResponse && (body = (response = (MutableHttpResponse)object).getBody()).isPresent() && Publishers.isConvertibleToPublisher(o = body.get())) {
                                Class<?> type = o.getClass();
                                Publisher resultPublisher = (Publisher)Publishers.convertPublisher(o, Publisher.class);
                                ScopePropagationPublisher scopedPublisher = new ScopePropagationPublisher(resultPublisher, TracingPublisher.this.tracer, span);
                                response.body(Publishers.convertPublisher(scopedPublisher, type));
                            }
                            TracingPublisher.this.doOnNext(object, span);
                            actual.onNext(object);
                            if (TracingPublisher.this.isSingle) {
                                this.finished = true;
                                TracingPublisher.this.doOnFinish(span);
                            }
                        }
                        finally {
                            if (finishAfterNext) {
                                span.finish();
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onError(Throwable t) {
                        try (NoopScopeManager.NoopScope ignored = scopeManager.activeSpan() != span ? scopeManager.activate(span) : NoopScopeManager.NoopScope.INSTANCE;){
                            TracingPublisher.this.onError(t, span);
                            actual.onError(t);
                            this.finished = true;
                        }
                        finally {
                            if (finishOnClose) {
                                span.finish();
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onComplete() {
                        block17: {
                            if (!this.finished) {
                                try (NoopScopeManager.NoopScope ignored = scopeManager.activeSpan() != span ? scopeManager.activate(span) : NoopScopeManager.NoopScope.INSTANCE;){
                                    actual.onComplete();
                                    TracingPublisher.this.doOnFinish(span);
                                    break block17;
                                }
                                finally {
                                    if (finishOnClose) {
                                        span.finish();
                                    }
                                }
                            }
                            actual.onComplete();
                        }
                    }
                });
            }
        } else {
            this.publisher.subscribe(actual);
        }
    }

    protected void doOnNext(@Nonnull T object, @Nonnull Span span) {
    }

    protected void doOnSubscribe(@Nonnull Span span) {
    }

    protected void doOnFinish(@Nonnull Span span) {
    }

    protected void doOnError(@Nonnull Throwable throwable, @Nonnull Span span) {
    }

    private void onError(Throwable t, Span span) {
        TraceInterceptor.logError(span, t);
        this.doOnError(t, span);
    }
}

