/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.util;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.Tracer;

public class TracingRunnable
implements Runnable {
    private final Runnable runnable;
    private final Tracer tracer;
    private final Span span;

    public TracingRunnable(Runnable runnable, Tracer tracer) {
        this.runnable = runnable;
        this.tracer = tracer;
        this.span = this.getSpan(tracer);
    }

    @Override
    public void run() {
        if (this.span != null) {
            ScopeManager scopeManager = this.tracer.scopeManager();
            if (scopeManager.activeSpan() != this.span) {
                try (Scope ignored = scopeManager.activate(this.span);){
                    this.runnable.run();
                }
            } else {
                this.runnable.run();
            }
        } else {
            this.runnable.run();
        }
    }

    private Span getSpan(Tracer tracer) {
        return tracer.scopeManager().activeSpan();
    }
}

