/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.util;

import io.micronaut.context.annotation.Requires;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.micronaut.tracing.instrument.util.TracingRunnable;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Singleton;

@Singleton
@Requires(beans={Tracer.class})
public class TracingRunnableInstrumenter
implements Function<Runnable, Runnable>,
RunnableInstrumenter,
ReactiveInstrumenter {
    private final Tracer tracer;

    public TracingRunnableInstrumenter(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Runnable apply(Runnable runnable) {
        return new TracingRunnable(runnable, this.tracer);
    }

    public Runnable instrument(Runnable command) {
        return this.apply(command);
    }

    public Optional<RunnableInstrumenter> newInstrumentation() {
        final ScopeManager scopeManager = this.tracer.scopeManager();
        final Span activeSpan = scopeManager.activeSpan();
        if (activeSpan != null) {
            return Optional.of(new RunnableInstrumenter(){

                public Runnable instrument(Runnable command) {
                    return () -> {
                        Span currentSpan = scopeManager.activeSpan();
                        if (currentSpan != activeSpan) {
                            try (Scope ignored = scopeManager.activate(activeSpan);){
                                command.run();
                            }
                        } else {
                            command.run();
                        }
                    };
                }
            });
        }
        return Optional.empty();
    }
}

