/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave;

import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.ReactiveInvocationInstrumenterFactory;
import io.micronaut.tracing.instrument.util.TracingInvocationInstrumenterFactory;
import jakarta.inject.Singleton;
import java.util.function.Supplier;

@Singleton
@Requires(beans={Tracing.class})
@Internal
public final class BraveTracingInvocationInstrumenter
implements ReactiveInvocationInstrumenterFactory,
TracingInvocationInstrumenterFactory {
    private final Supplier<CurrentTraceContext> currentTraceContext = SupplierUtil.memoized(() -> ((Tracing)tracing.get()).currentTraceContext());

    public BraveTracingInvocationInstrumenter(BeanProvider<Tracing> tracing) {
    }

    public InvocationInstrumenter newReactiveInvocationInstrumenter() {
        return this.newTracingInvocationInstrumenter();
    }

    @Override
    public InvocationInstrumenter newTracingInvocationInstrumenter() {
        CurrentTraceContext currentTraceContext = this.currentTraceContext.get();
        TraceContext invocationContext = currentTraceContext.get();
        if (invocationContext != null) {
            return () -> {
                CurrentTraceContext.Scope activeScope = currentTraceContext.maybeScope(invocationContext);
                return cleanup -> activeScope.close();
            };
        }
        return null;
    }
}

