/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpTracing;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.tracing.instrument.http.TraceRequestAttributes;
import java.util.Optional;

abstract class AbstractBraveTracingFilter
implements HttpFilter {
    protected final HttpTracing httpTracing;

    AbstractBraveTracingFilter(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
    }

    void withSpanInScope(HttpRequest<?> request, Span span) {
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        Tracer.SpanInScope spanInScope = this.httpTracing.tracing().tracer().withSpanInScope(span);
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SCOPE, (Object)spanInScope);
    }

    void afterTerminate(HttpRequest<?> request) {
        Optional scope = request.removeAttribute((CharSequence)TraceRequestAttributes.CURRENT_SCOPE, Tracer.SpanInScope.class);
        scope.ifPresent(Tracer.SpanInScope::close);
    }

    Optional<Span> configuredSpan(HttpRequest<?> request, HttpResponse<?> response) {
        Optional routeTemplate = request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE);
        routeTemplate.ifPresent(o -> response.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, o));
        response.setAttribute((CharSequence)HttpAttributes.METHOD_NAME, (Object)request.getMethodName());
        return request.getAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, Span.class);
    }
}

