/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.http;

import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MutableHttpHeaders;
import io.opentracing.propagation.TextMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class HttpHeadersTextMap
implements TextMap {
    private final HttpHeaders headers;

    HttpHeadersTextMap(HttpHeaders headers) {
        this.headers = headers;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        final Iterator i = this.headers.iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                final Map.Entry entry = (Map.Entry)i.next();
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return (String)entry.getKey();
                    }

                    @Override
                    public String getValue() {
                        List value = (List)entry.getValue();
                        if (CollectionUtils.isNotEmpty((Collection)value)) {
                            return (String)value.get(0);
                        }
                        return null;
                    }

                    @Override
                    public String setValue(String value) {
                        String v = this.getValue();
                        entry.setValue(Collections.singletonList(value));
                        return v;
                    }
                };
            }
        };
    }

    public void put(String key, String value) {
        if (this.headers instanceof MutableHttpHeaders) {
            ((MutableHttpHeaders)this.headers).add((CharSequence)key, (CharSequence)value);
        }
    }
}

