/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.util;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import io.micronaut.scheduling.instrument.ReactiveInvocationInstrumenterFactory;
import jakarta.inject.Singleton;
import java.util.Map;
import org.slf4j.MDC;

@Singleton
@Requires(classes={MDC.class})
@Internal
public final class MdcInstrumenter
implements InvocationInstrumenterFactory,
ReactiveInvocationInstrumenterFactory {
    public InvocationInstrumenter newInvocationInstrumenter() {
        Map contextMap = MDC.getCopyOfContextMap();
        return () -> {
            Map oldContextMap = MDC.getCopyOfContextMap();
            if (contextMap != null && !contextMap.isEmpty()) {
                MDC.setContextMap((Map)contextMap);
            }
            return cleanup -> {
                if (oldContextMap != null && !oldContextMap.isEmpty()) {
                    MDC.setContextMap((Map)oldContextMap);
                } else {
                    MDC.clear();
                }
            };
        };
    }

    public InvocationInstrumenter newReactiveInvocationInstrumenter() {
        return this.newInvocationInstrumenter();
    }
}

