/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.jaeger;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.tracing.jaeger.JaegerConfiguration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;

@Factory
@Requirements(value={@Requires(classes={JaegerTracer.Builder.class}), @Requires(beans={JaegerConfiguration.class})})
public class JaegerTracerFactory
implements Closeable {
    private final JaegerConfiguration configuration;
    private Reporter reporter;
    private Sampler sampler;

    public JaegerTracerFactory(JaegerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setReporter(@Nullable Reporter reporter) {
        this.reporter = reporter;
    }

    @Inject
    public void setSampler(@Nullable Sampler sampler) {
        this.sampler = sampler;
    }

    @Singleton
    @Primary
    @Requires(classes={JaegerTracer.Builder.class})
    Configuration jaegerConfiguration() {
        return this.configuration.getConfiguration();
    }

    @Singleton
    @Primary
    @Requires(classes={JaegerTracer.Builder.class})
    JaegerTracer.Builder jaegerTracerBuilder(Configuration configuration) {
        JaegerTracer.Builder tracerBuilder = this.resolveBuilder(configuration);
        if (this.configuration.isExpandExceptionLogs()) {
            tracerBuilder.withExpandExceptionLogs();
        }
        if (this.configuration.isZipkinSharedRpcSpan()) {
            tracerBuilder.withZipkinSharedRpcSpan();
        }
        if (this.reporter != null) {
            tracerBuilder.withReporter(this.reporter);
        }
        if (this.sampler != null) {
            tracerBuilder.withSampler(this.sampler);
        }
        return tracerBuilder;
    }

    @Singleton
    @Primary
    @Requires(classes={JaegerTracer.Builder.class})
    Tracer jaegerTracer(JaegerTracer.Builder tracerBuilder) {
        JaegerTracer tracer = tracerBuilder.build();
        GlobalTracer.registerIfAbsent((Tracer)tracer);
        return tracer;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.configuration.getConfiguration().closeTracer();
    }

    protected void customizeConfiguration(Configuration configuration) {
    }

    private JaegerTracer.Builder resolveBuilder(Configuration configuration) {
        this.customizeConfiguration(configuration);
        return configuration.getTracerBuilder();
    }
}

