/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.util;

import io.micronaut.core.async.publisher.Publishers;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ScopePropagationPublisher<T>
implements Publishers.MicronautPublisher<T> {
    private final Publisher<T> publisher;
    private final Tracer tracer;
    private final Span parentSpan;

    public ScopePropagationPublisher(Publisher<T> publisher, Tracer tracer, Span parentSpan) {
        this.publisher = publisher;
        this.tracer = tracer;
        this.parentSpan = parentSpan;
    }

    public void subscribe(final Subscriber<? super T> actual) {
        final Span span = this.parentSpan;
        if (span != null) {
            try (Scope ignored = this.tracer.scopeManager().activate(span);){
                this.publisher.subscribe(new Subscriber<T>(){

                    public void onSubscribe(Subscription s) {
                        try (Scope ignored = ScopePropagationPublisher.this.tracer.scopeManager().activate(span);){
                            actual.onSubscribe(s);
                        }
                    }

                    public void onNext(T object) {
                        try (Scope ignored = ScopePropagationPublisher.this.tracer.scopeManager().activate(span);){
                            actual.onNext(object);
                        }
                    }

                    public void onError(Throwable t) {
                        try (Scope ignored = ScopePropagationPublisher.this.tracer.scopeManager().activate(span);){
                            actual.onError(t);
                        }
                    }

                    public void onComplete() {
                        try (Scope ignored = ScopePropagationPublisher.this.tracer.scopeManager().activate(span);){
                            actual.onComplete();
                        }
                    }
                });
            }
        } else {
            this.publisher.subscribe(actual);
        }
    }
}

