/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.tracing.annotation.SpanTag;
import io.opentracing.Span;
import io.opentracing.Tracer;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Optional;

@Singleton
@Requires(beans={Tracer.class})
public class TraceInterceptor
implements MethodInterceptor<Object, Object> {
    public static final String CLASS_TAG = "class";
    public static final String METHOD_TAG = "method";
    private static final String TAG_HYSTRIX_COMMAND = "hystrix.command";
    private static final String TAG_HYSTRIX_GROUP = "hystrix.group";
    private static final String TAG_HYSTRIX_THREAD_POOL = "hystrix.threadPool";
    private static final String HYSTRIX_ANNOTATION = "io.micronaut.configuration.hystrix.annotation.HystrixCommand";
    private final Tracer tracer;
    private final ConversionService<?> conversionService;

    public TraceInterceptor(Tracer tracer, ConversionService<?> conversionService) {
        this.tracer = tracer;
        this.conversionService = conversionService;
    }

    public int getOrder() {
        return InterceptPhase.TRACE.getPosition();
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 22[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void populateTags(MethodInvocationContext<Object, Object> context, Optional<String> hystrixCommand, Span span) {
        span.setTag(CLASS_TAG, context.getDeclaringType().getSimpleName());
        span.setTag(METHOD_TAG, context.getMethodName());
        hystrixCommand.ifPresent(s -> span.setTag(TAG_HYSTRIX_COMMAND, s));
        context.stringValue(HYSTRIX_ANNOTATION, "group").ifPresent(s -> span.setTag(TAG_HYSTRIX_GROUP, s));
        context.stringValue(HYSTRIX_ANNOTATION, "threadPool").ifPresent(s -> span.setTag(TAG_HYSTRIX_THREAD_POOL, s));
        this.tagArguments(span, context);
    }

    public static void logError(Span span, Throwable e) {
        HashMap<String, Object> fields = new HashMap<String, Object>(2);
        fields.put("error.object", e);
        String message = e.getMessage();
        if (message != null) {
            fields.put("message", message);
        }
        span.log(fields);
    }

    private void tagArguments(Span span, MethodInvocationContext<Object, Object> context) {
        Argument[] arguments = context.getArguments();
        Object[] parameterValues = context.getParameterValues();
        for (int i = 0; i < arguments.length; ++i) {
            Object v;
            Argument argument = arguments[i];
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            if (!annotationMetadata.hasAnnotation(SpanTag.class) || (v = parameterValues[i]) == null) continue;
            String tagName = annotationMetadata.stringValue(SpanTag.class).orElse(argument.getName());
            span.setTag(tagName, v.toString());
        }
    }

    private static /* synthetic */ void lambda$intercept$0(Span span, Object o, Throwable throwable) {
        if (throwable != null) {
            TraceInterceptor.logError(span, throwable);
        }
        span.finish();
    }
}

