/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.http;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.tracing.brave.instrument.http.BraveTracingClientFilter;
import io.micronaut.tracing.instrument.http.AbstractOpenTracingFilter;
import io.micronaut.tracing.instrument.http.HttpHeadersTextMap;
import io.micronaut.tracing.instrument.http.TraceRequestAttributes;
import io.micronaut.tracing.instrument.util.TracingPublisher;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracer;
import io.opentracing.propagation.Format;
import org.reactivestreams.Publisher;

@Filter(value={"${tracing.http.client.path:/**}"})
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(missingBeans={NoopTracer.class}), @Requires(missingBeans={BraveTracingClientFilter.class})})
public class OpenTracingClientFilter
extends AbstractOpenTracingFilter
implements HttpClientFilter {
    public OpenTracingClientFilter(Tracer tracer) {
        super(tracer);
    }

    public Publisher<? extends HttpResponse<?>> doFilter(final MutableHttpRequest<?> request, ClientFilterChain chain) {
        Publisher requestPublisher = chain.proceed(request);
        Span activeSpan = this.tracer.scopeManager().activeSpan();
        SpanContext activeContext = activeSpan != null ? activeSpan.context() : null;
        Tracer.SpanBuilder spanBuilder = this.newSpan((HttpRequest<?>)request, activeContext);
        return new TracingPublisher(requestPublisher, this.tracer, spanBuilder, true){

            @Override
            protected void doOnSubscribe(@NonNull Span span) {
                span.setTag("http.client", true);
                SpanContext spanContext = span.context();
                OpenTracingClientFilter.this.tracer.inject(spanContext, Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersTextMap((HttpHeaders)request.getHeaders()));
                request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN_CONTEXT, (Object)spanContext);
                request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
            }

            protected void doOnNext(@NonNull Object object, @NonNull Span span) {
                if (object instanceof HttpResponse) {
                    OpenTracingClientFilter.this.setResponseTags((HttpRequest<?>)request, (HttpResponse<?>)((HttpResponse)object), span);
                }
            }

            @Override
            protected void doOnError(@NonNull Throwable error, @NonNull Span span) {
                if (error instanceof HttpClientResponseException) {
                    HttpClientResponseException e = (HttpClientResponseException)error;
                    HttpResponse response = e.getResponse();
                    OpenTracingClientFilter.this.setResponseTags((HttpRequest<?>)request, (HttpResponse<?>)response, span);
                }
                OpenTracingClientFilter.this.setErrorTags(span, error);
            }
        };
    }
}

