/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.core.convert;

import com.mongodb.ServerAddress;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Optional;

public class StringToServerAddressConverter
implements TypeConverter<CharSequence, ServerAddress> {
    public Optional<ServerAddress> convert(CharSequence object, Class<ServerAddress> targetType, ConversionContext context) {
        String address = object.toString();
        if (address.contains(":")) {
            String[] hostAndPort = address.split(":");
            try {
                return Optional.of(new ServerAddress(hostAndPort[0], Integer.valueOf(hostAndPort[1]).intValue()));
            }
            catch (NumberFormatException e) {
                context.reject((Object)address, (Exception)e);
                return Optional.empty();
            }
        }
        return Optional.of(new ServerAddress(address));
    }
}

