/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.core.serde;

import io.micronaut.configuration.mongo.core.serde.SerdeCodec;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.annotation.Serdeable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

@Internal
public final class DataCodecRegistry
implements CodecRegistry {
    @Nullable
    private final Collection<Class<?>> entities;
    private final SerdeRegistry serdeRegistry;
    private final Map<Class, Codec> codecs = new ConcurrentHashMap<Class, Codec>();

    public DataCodecRegistry(@Nullable Collection<Class<?>> entities, SerdeRegistry serdeRegistry) {
        this.entities = entities;
        this.serdeRegistry = serdeRegistry;
    }

    public <T> Codec<T> get(Class<T> clazz) {
        throw new CodecConfigurationException("Not supported");
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        BeanIntrospection beanIntrospection;
        SerdeCodec<T> codec = this.codecs.get(clazz);
        if (codec != null) {
            return codec;
        }
        if (clazz.isEnum() || this.entities != null && !this.entities.contains(clazz)) {
            return null;
        }
        Optional introspection = BeanIntrospector.SHARED.findIntrospection(clazz);
        if (introspection.isPresent() && ((beanIntrospection = (BeanIntrospection)introspection.get()).hasStereotype(Serdeable.Serializable.class) || beanIntrospection.hasStereotype(Serdeable.Deserializable.class))) {
            codec = new SerdeCodec<T>(this.serdeRegistry, clazz, registry);
            this.codecs.put(clazz, codec);
            return codec;
        }
        return null;
    }
}

